/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.compress;

import cool.taomu.compress.impl.GZipCompress;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class GzUtils {
  public static byte[] zip(final byte[] arg) {
    try {
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      byte[] result = new byte[0];
      try (GZipCompress gzip = new GZipCompress()) {
        OutputStream _compression = gzip.compression(baos);
        GZIPOutputStream out = ((GZIPOutputStream) _compression);
        out.write(arg);
        out.finish();
        result = baos.toByteArray();
      }
      return result;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static byte[] unzip(final byte[] arg) {
    try {
      ByteArrayInputStream bais = new ByteArrayInputStream(arg);
      try (GZipCompress gzip = new GZipCompress()) {
        InputStream input = gzip.decompression(bais);
        return IOUtils.toByteArray(input);
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static void main(final String[] args) {
    TarGzUtils.zcvf("/Users/rcmu/workspace/gradle.properties", "/Users/rcmu/a.tar.gz");
  }
}
