/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.compress;

import cool.taomu.compress.impl.GZipCompress;
import cool.taomu.compress.impl.TarCompress;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class TarGzUtils {
  private static final Logger LOG = LoggerFactory.getLogger(TarGzUtils.class);
  
  public static void zcvf(final String src, final String dest) {
    try {
      try (FileOutputStream f = new Function0<FileOutputStream>() {
        @Override
        public FileOutputStream apply() {
          try {
            return new FileOutputStream(dest);
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      }.apply()) {
        try (TarCompress tar = new TarCompress(new GZipCompress())) {
          BufferedOutputStream _bufferedOutputStream = new BufferedOutputStream(f);
          OutputStream _compression = tar.compression(_bufferedOutputStream);
          TarArchiveOutputStream taos = ((TarArchiveOutputStream) _compression);
          TarGzUtils.addFilesToTarGz(src, "", taos);
        }
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  private static void addFilesToTarGz(final String src, final String parent, final TarArchiveOutputStream tarAos) throws IOException {
    File file = new File(src);
    String _name = file.getName();
    String name = (parent + _name);
    TarArchiveEntry _tarArchiveEntry = new TarArchiveEntry(file, name);
    tarAos.putArchiveEntry(_tarArchiveEntry);
    boolean _isFile = file.isFile();
    if (_isFile) {
      try (FileInputStream fis = new Function0<FileInputStream>() {
        @Override
        public FileInputStream apply() {
          try {
            return new FileInputStream(file);
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      }.apply()) {
        BufferedInputStream bis = new BufferedInputStream(fis);
        IOUtils.copy(bis, tarAos);
        tarAos.closeArchiveEntry();
        bis.close();
      }
    } else {
      boolean _isDirectory = file.isDirectory();
      if (_isDirectory) {
        tarAos.closeArchiveEntry();
        File[] _listFiles = file.listFiles();
        for (final File f : _listFiles) {
          TarGzUtils.addFilesToTarGz(f.getAbsolutePath(), (name + File.separator), tarAos);
        }
      }
    }
  }
}
