/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.compress.impl;

import cool.taomu.compress.inter.ICompress;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class GZipCompress implements ICompress {
  private ICompress ics;
  
  private OutputStream output;
  
  private InputStream input;
  
  public GZipCompress() {
  }
  
  public GZipCompress(final ICompress ics) {
    this.ics = ics;
  }
  
  @Override
  public OutputStream compression(final OutputStream out) {
    try {
      if ((this.ics != null)) {
        OutputStream _compression = this.ics.compression(out);
        GZIPOutputStream _gZIPOutputStream = new GZIPOutputStream(_compression);
        this.output = _gZIPOutputStream;
        return this.output;
      } else {
        GZIPOutputStream _gZIPOutputStream_1 = new GZIPOutputStream(out);
        this.output = _gZIPOutputStream_1;
        return this.output;
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Override
  public InputStream decompression(final InputStream input) {
    try {
      GZIPInputStream _gZIPInputStream = new GZIPInputStream(input);
      this.input = _gZIPInputStream;
      if ((this.ics != null)) {
        return this.ics.decompression(this.input);
      } else {
        return this.input;
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  @Override
  public void close() throws Exception {
    if ((this.output != null)) {
      this.output.close();
    }
    if ((this.input != null)) {
      this.input.close();
    }
    if ((this.ics != null)) {
      this.ics.close();
    }
  }
}
