/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.compress.impl;

import cool.taomu.compress.inter.ICompress;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

@SuppressWarnings("all")
public class TarCompress implements ICompress {
  private ICompress ics;
  
  private OutputStream output;
  
  private InputStream input;
  
  public TarCompress() {
  }
  
  public TarCompress(final ICompress ics) {
    this.ics = ics;
  }
  
  @Override
  public OutputStream compression(final OutputStream out) {
    if ((this.ics != null)) {
      OutputStream _compression = this.ics.compression(out);
      TarArchiveOutputStream toutput = new TarArchiveOutputStream(_compression);
      toutput.setLongFileMode(TarArchiveOutputStream.LONGFILE_POSIX);
      this.output = toutput;
      return this.output;
    } else {
      TarArchiveOutputStream toutput_1 = new TarArchiveOutputStream(out);
      toutput_1.setLongFileMode(TarArchiveOutputStream.LONGFILE_POSIX);
      this.output = toutput_1;
      return this.output;
    }
  }
  
  @Override
  public InputStream decompression(final InputStream input) {
    TarArchiveInputStream tinput = new TarArchiveInputStream(input);
    this.input = tinput;
    if ((this.ics != null)) {
      return this.ics.decompression(this.input);
    } else {
      return this.input;
    }
  }
  
  @Override
  public void close() throws Exception {
    if ((this.output != null)) {
      this.output.close();
    }
    if ((this.input != null)) {
      this.input.close();
    }
    if ((this.ics != null)) {
      this.ics.close();
    }
  }
}
