/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.compress.impl;

import cool.taomu.compress.inter.ICompress;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class GZipCompress
implements ICompress {
    private ICompress ics;
    private OutputStream output;
    private InputStream input;

    public GZipCompress() {
    }

    public GZipCompress(ICompress ics) {
        this.ics = ics;
    }

    @Override
    public OutputStream compression(OutputStream out) {
        try {
            if (this.ics != null) {
                OutputStream _compression = this.ics.compression(out);
                GZIPOutputStream _gZIPOutputStream = new GZIPOutputStream(_compression);
                this.output = _gZIPOutputStream;
                return this.output;
            }
            GZIPOutputStream _gZIPOutputStream_1 = new GZIPOutputStream(out);
            this.output = _gZIPOutputStream_1;
            return this.output;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public InputStream decompression(InputStream input) {
        try {
            GZIPInputStream _gZIPInputStream = new GZIPInputStream(input);
            this.input = _gZIPInputStream;
            if (this.ics != null) {
                return this.ics.decompression(this.input);
            }
            return this.input;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.output != null) {
            this.output.close();
        }
        if (this.input != null) {
            this.input.close();
        }
        if (this.ics != null) {
            this.ics.close();
        }
    }
}

