/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.compress;

import cool.taomu.compress.impl.GZipCompress;
import cool.taomu.compress.impl.TarCompress;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarGzUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TarGzUtils.class);

    public static void zcvf(String src, final String dest) {
        try (FileOutputStream f = new Functions.Function0<FileOutputStream>(){

            public FileOutputStream apply() {
                try {
                    return new FileOutputStream(dest);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        }.apply();
             TarCompress tar = new TarCompress(new GZipCompress());){
            BufferedOutputStream _bufferedOutputStream = new BufferedOutputStream(f);
            OutputStream _compression = tar.compression(_bufferedOutputStream);
            TarArchiveOutputStream taos = (TarArchiveOutputStream)_compression;
            TarGzUtils.addFilesToTarGz(src, "", taos);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private static void addFilesToTarGz(String src, String parent, TarArchiveOutputStream tarAos) throws IOException {
        final File file = new File(src);
        String _name = file.getName();
        String name = parent + _name;
        TarArchiveEntry _tarArchiveEntry = new TarArchiveEntry(file, name);
        tarAos.putArchiveEntry((ArchiveEntry)_tarArchiveEntry);
        boolean _isFile = file.isFile();
        if (_isFile) {
            try (FileInputStream fis = new Functions.Function0<FileInputStream>(){

                public FileInputStream apply() {
                    try {
                        return new FileInputStream(file);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            }.apply();){
                BufferedInputStream bis = new BufferedInputStream(fis);
                IOUtils.copy((InputStream)bis, (OutputStream)tarAos);
                tarAos.closeArchiveEntry();
                bis.close();
            }
        } else {
            boolean _isDirectory = file.isDirectory();
            if (_isDirectory) {
                File[] _listFiles;
                tarAos.closeArchiveEntry();
                for (File f : _listFiles = file.listFiles()) {
                    TarGzUtils.addFilesToTarGz(f.getAbsolutePath(), name + File.separator, tarAos);
                }
            }
        }
    }
}

