/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpProgressMonitor;
import cool.taomu.ssh.SftpProgresssMonitorImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JschUtils
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(JschUtils.class);
    private Session session = null;

    public JschUtils(String host, String uname, String upass, int port) {
        try {
            JSch jsch = new JSch();
            this.session = jsch.getSession(uname, host, port);
            this.session.setPassword(upass);
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.session.setConfig(config);
            this.session.setTimeout(60000000);
            this.session.connect();
            boolean _isConnected = this.session.isConnected();
            if (_isConnected) {
                LOG.info("\u94fe\u63a5\u6210\u529f");
            } else {
                LOG.info("\u94fe\u63a5\u5931\u8d25");
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception ex = (Exception)_t;
                LOG.info("\u5931\u8d25", (Throwable)ex);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    public Ssh Ssh() {
        return new Ssh(this.session);
    }

    public Sftp Sftp() {
        return new Sftp(this.session);
    }

    public Shell Shell() {
        return new Shell(this.session);
    }

    public static class Shell
    implements AutoCloseable {
        private ChannelShell channel = null;

        public Shell(Session session) {
            try {
                Channel _openChannel = session.openChannel("shell");
                this.channel = (ChannelShell)_openChannel;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        /*
         * Exception decompiling
         */
        public String exec(String[] content) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void close() throws Exception {
            if (this.channel != null) {
                this.channel.disconnect();
            }
        }
    }

    @Accessors
    public static class Sftp
    implements AutoCloseable {
        private ChannelSftp sftp = null;

        public Sftp(Session session) {
            try {
                Channel channel = session.openChannel("sftp");
                this.sftp = (ChannelSftp)channel;
                this.sftp.connect();
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        @Override
        public void close() throws Exception {
            if (this.sftp != null) {
                this.sftp.disconnect();
            }
        }

        public byte[] get(String file) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                SftpProgresssMonitorImpl _sftpProgresssMonitorImpl = new SftpProgresssMonitorImpl();
                this.sftp.get(file, (OutputStream)bos, (SftpProgressMonitor)_sftpProgresssMonitorImpl);
                return bos.toByteArray();
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        public void get(String src, String dst) {
            try {
                SftpProgresssMonitorImpl _sftpProgresssMonitorImpl = new SftpProgresssMonitorImpl();
                this.sftp.get(src, dst, (SftpProgressMonitor)_sftpProgresssMonitorImpl);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        public void put(String file, byte[] content) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(content);
                SftpProgresssMonitorImpl _sftpProgresssMonitorImpl = new SftpProgresssMonitorImpl();
                this.sftp.put((InputStream)bis, file, (SftpProgressMonitor)_sftpProgresssMonitorImpl);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        public void put(String src, String dst) {
            try {
                SftpProgresssMonitorImpl _sftpProgresssMonitorImpl = new SftpProgresssMonitorImpl();
                this.sftp.put(src, dst, (SftpProgressMonitor)_sftpProgresssMonitorImpl);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        @Pure
        public ChannelSftp getSftp() {
            return this.sftp;
        }

        public void setSftp(ChannelSftp sftp) {
            this.sftp = sftp;
        }
    }

    public static class Ssh
    implements AutoCloseable {
        private ChannelExec exec = null;

        public Ssh(Session session) {
            try {
                Channel channel = session.openChannel("exec");
                this.exec = (ChannelExec)channel;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        public String exec(String cmd, String charset) {
            try {
                this.exec.setCommand(cmd);
                this.exec.connect();
                InputStream input = this.exec.getInputStream();
                return IOUtils.toString((InputStream)input, (String)charset);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }

        @Override
        public void close() throws Exception {
            if (this.exec != null) {
                this.exec.disconnect();
            }
        }
    }
}

