/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.smb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * SmbUtils.download(new SmbFile("smb://admin:purplekayak675@192.168.1.4/share_sda1/stock_download/"), new File("./usecase/"));
 * SmbUtils.upload(new File("/home/rcmu/workspace/test"),new SmbFile("smb://admin:purplekayak675@192.168.1.4/share_sda1/"));
 */
@SuppressWarnings("all")
public class SmbUtils {
  public interface LocalLoader {
    void loader(final OutputStream out);
  }
  
  private static final Logger LOG = LoggerFactory.getLogger(SmbUtils.class);
  
  public static void download(final SmbFile smbFile, final File localFile) {
    try {
      boolean _exists = smbFile.exists();
      if (_exists) {
        SmbFile[] sfiles = smbFile.listFiles();
        final SmbFile[] _converted_sfiles = (SmbFile[])sfiles;
        final Consumer<SmbFile> _function = (SmbFile it) -> {
          try {
            boolean _isDirectory = it.isDirectory();
            if (_isDirectory) {
              String _absolutePath = localFile.getAbsolutePath();
              String _name = it.getName();
              String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_absolutePath, _name)), File.separator);
              File dir = new File(_join);
              boolean _exists_1 = dir.exists();
              boolean _not = (!_exists_1);
              if (_not) {
                dir.mkdirs();
              }
              SmbUtils.download(it, dir);
            } else {
              boolean _isFile = it.isFile();
              if (_isFile) {
                if (((localFile != null) && localFile.exists())) {
                  SmbUtils.LOG.info("下载{} 至 {}", it.getPath(), localFile.getAbsolutePath());
                  try (BufferedInputStream in = new Function0<BufferedInputStream>() {
                    @Override
                    public BufferedInputStream apply() {
                      try {
                        SmbFileInputStream _smbFileInputStream = new SmbFileInputStream(it);
                        return new BufferedInputStream(_smbFileInputStream);
                      } catch (Throwable _e) {
                        throw Exceptions.sneakyThrow(_e);
                      }
                    }
                  }.apply()) {
                    try (BufferedOutputStream out = new Function0<BufferedOutputStream>() {
                      @Override
                      public BufferedOutputStream apply() {
                        try {
                          String _absolutePath = localFile.getAbsolutePath();
                          String _name = it.getName();
                          String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_absolutePath, _name)), File.separator);
                          File _file = new File(_join);
                          FileOutputStream _fileOutputStream = new FileOutputStream(_file);
                          return new BufferedOutputStream(_fileOutputStream);
                        } catch (Throwable _e) {
                          throw Exceptions.sneakyThrow(_e);
                        }
                      }
                    }.apply()) {
                      IOUtils.copy(in, out);
                    }
                  } catch (final Throwable _t) {
                    if (_t instanceof Exception) {
                      final Exception ex = (Exception)_t;
                      ex.printStackTrace();
                    } else {
                      throw Exceptions.sneakyThrow(_t);
                    }
                  }
                }
              }
            }
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        };
        ((List<SmbFile>)Conversions.doWrapArray(_converted_sfiles)).forEach(_function);
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static void upload(final File localFile, final SmbFile smbFile) {
    boolean _exists = localFile.exists();
    if (_exists) {
      File[] sfiles = localFile.listFiles();
      final File[] _converted_sfiles = (File[])sfiles;
      final Consumer<File> _function = (File it) -> {
        try {
          boolean _isDirectory = it.isDirectory();
          if (_isDirectory) {
            String _path = smbFile.getPath();
            String _name = it.getName();
            String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_path, _name)), File.separator);
            SmbFile dir = new SmbFile(_join);
            boolean _exists_1 = dir.exists();
            boolean _not = (!_exists_1);
            if (_not) {
              dir.mkdirs();
            }
            SmbUtils.upload(it, dir);
          } else {
            boolean _isFile = it.isFile();
            if (_isFile) {
              if (((smbFile != null) && smbFile.exists())) {
                SmbUtils.LOG.info("上传 {} 至 {}", localFile.getAbsolutePath(), it.getPath());
                try (BufferedInputStream in = new Function0<BufferedInputStream>() {
                  @Override
                  public BufferedInputStream apply() {
                    try {
                      FileInputStream _fileInputStream = new FileInputStream(it);
                      return new BufferedInputStream(_fileInputStream);
                    } catch (Throwable _e) {
                      throw Exceptions.sneakyThrow(_e);
                    }
                  }
                }.apply()) {
                  try (BufferedOutputStream out = new Function0<BufferedOutputStream>() {
                    @Override
                    public BufferedOutputStream apply() {
                      try {
                        String _path = smbFile.getPath();
                        String _name = it.getName();
                        String _join = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_path, _name)), File.separator);
                        SmbFile _smbFile = new SmbFile(_join);
                        SmbFileOutputStream _smbFileOutputStream = new SmbFileOutputStream(_smbFile);
                        return new BufferedOutputStream(_smbFileOutputStream);
                      } catch (Throwable _e) {
                        throw Exceptions.sneakyThrow(_e);
                      }
                    }
                  }.apply()) {
                    IOUtils.copy(in, out);
                  }
                } catch (final Throwable _t) {
                  if (_t instanceof Exception) {
                    final Exception ex = (Exception)_t;
                    ex.printStackTrace();
                  } else {
                    throw Exceptions.sneakyThrow(_t);
                  }
                }
              }
            }
          }
        } catch (Throwable _e) {
          throw Exceptions.sneakyThrow(_e);
        }
      };
      ((List<File>)Conversions.doWrapArray(_converted_sfiles)).forEach(_function);
    }
  }
  
  public static InputStream downloadOneFile(final SmbFile smbFile) {
    try {
      SmbFileInputStream _smbFileInputStream = new SmbFileInputStream(smbFile);
      BufferedInputStream in = new BufferedInputStream(_smbFileInputStream);
      return in;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public static void uploadOneFile(final SmbFile smbFile, final SmbUtils.LocalLoader ll) {
    try {
      try (BufferedOutputStream out = new Function0<BufferedOutputStream>() {
        @Override
        public BufferedOutputStream apply() {
          try {
            SmbFileOutputStream _smbFileOutputStream = new SmbFileOutputStream(smbFile);
            return new BufferedOutputStream(_smbFileOutputStream);
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      }.apply()) {
        if ((ll != null)) {
          ll.loader(out);
        }
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
