/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.smb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SmbUtils.class);

    public static void download(SmbFile smbFile, final File localFile) {
        try {
            boolean _exists = smbFile.exists();
            if (_exists) {
                SmbFile[] sfiles;
                SmbFile[] _converted_sfiles = sfiles = smbFile.listFiles();
                Consumer<SmbFile> _function = it -> {
                    block19: {
                        try {
                            boolean _isDirectory = it.isDirectory();
                            if (_isDirectory) {
                                boolean _not;
                                String _absolutePath = localFile.getAbsolutePath();
                                String _name = it.getName();
                                String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_absolutePath, _name})), (CharSequence)File.separator);
                                File dir = new File(_join);
                                boolean _exists_1 = dir.exists();
                                boolean bl = _not = !_exists_1;
                                if (_not) {
                                    dir.mkdirs();
                                }
                                SmbUtils.download(it, dir);
                                break block19;
                            }
                            boolean _isFile = it.isFile();
                            if (!_isFile || localFile == null || !localFile.exists()) break block19;
                            LOG.info("\u4e0b\u8f7d{} \u81f3 {}", (Object)it.getPath(), (Object)localFile.getAbsolutePath());
                            try (BufferedInputStream in = new Functions.Function0<BufferedInputStream>(){

                                public BufferedInputStream apply() {
                                    try {
                                        SmbFileInputStream _smbFileInputStream = new SmbFileInputStream(it);
                                        return new BufferedInputStream((InputStream)_smbFileInputStream);
                                    }
                                    catch (Throwable _e) {
                                        throw Exceptions.sneakyThrow((Throwable)_e);
                                    }
                                }
                            }.apply();
                                 BufferedOutputStream out = new Functions.Function0<BufferedOutputStream>(){

                                public BufferedOutputStream apply() {
                                    try {
                                        String _absolutePath = localFile.getAbsolutePath();
                                        String _name = it.getName();
                                        String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_absolutePath, _name})), (CharSequence)File.separator);
                                        File _file = new File(_join);
                                        FileOutputStream _fileOutputStream = new FileOutputStream(_file);
                                        return new BufferedOutputStream(_fileOutputStream);
                                    }
                                    catch (Throwable _e) {
                                        throw Exceptions.sneakyThrow((Throwable)_e);
                                    }
                                }
                            }.apply();){
                                IOUtils.copy((InputStream)in, (OutputStream)out);
                            }
                            catch (Throwable _t) {
                                if (_t instanceof Exception) {
                                    Exception ex = (Exception)_t;
                                    ex.printStackTrace();
                                    break block19;
                                }
                                throw Exceptions.sneakyThrow((Throwable)_t);
                            }
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    }
                };
                ((List)Conversions.doWrapArray((Object)_converted_sfiles)).forEach(_function);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void upload(File localFile, final SmbFile smbFile) {
        boolean _exists = localFile.exists();
        if (_exists) {
            File[] sfiles;
            File[] _converted_sfiles = sfiles = localFile.listFiles();
            Consumer<File> _function = it -> {
                block19: {
                    try {
                        boolean _isDirectory = it.isDirectory();
                        if (_isDirectory) {
                            boolean _not;
                            String _path = smbFile.getPath();
                            String _name = it.getName();
                            String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_path, _name})), (CharSequence)File.separator);
                            SmbFile dir = new SmbFile(_join);
                            boolean _exists_1 = dir.exists();
                            boolean bl = _not = !_exists_1;
                            if (_not) {
                                dir.mkdirs();
                            }
                            SmbUtils.upload(it, dir);
                            break block19;
                        }
                        boolean _isFile = it.isFile();
                        if (!_isFile || smbFile == null || !smbFile.exists()) break block19;
                        LOG.info("\u4e0a\u4f20 {} \u81f3 {}", (Object)localFile.getAbsolutePath(), (Object)it.getPath());
                        try (BufferedInputStream in = new Functions.Function0<BufferedInputStream>(){

                            public BufferedInputStream apply() {
                                try {
                                    FileInputStream _fileInputStream = new FileInputStream(it);
                                    return new BufferedInputStream(_fileInputStream);
                                }
                                catch (Throwable _e) {
                                    throw Exceptions.sneakyThrow((Throwable)_e);
                                }
                            }
                        }.apply();
                             BufferedOutputStream out = new Functions.Function0<BufferedOutputStream>(){

                            public BufferedOutputStream apply() {
                                try {
                                    String _path = smbFile.getPath();
                                    String _name = it.getName();
                                    String _join = IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_path, _name})), (CharSequence)File.separator);
                                    SmbFile _smbFile = new SmbFile(_join);
                                    SmbFileOutputStream _smbFileOutputStream = new SmbFileOutputStream(_smbFile);
                                    return new BufferedOutputStream((OutputStream)_smbFileOutputStream);
                                }
                                catch (Throwable _e) {
                                    throw Exceptions.sneakyThrow((Throwable)_e);
                                }
                            }
                        }.apply();){
                            IOUtils.copy((InputStream)in, (OutputStream)out);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Exception) {
                                Exception ex = (Exception)_t;
                                ex.printStackTrace();
                                break block19;
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            ((List)Conversions.doWrapArray((Object)_converted_sfiles)).forEach(_function);
        }
    }

    public static InputStream downloadOneFile(SmbFile smbFile) {
        try {
            SmbFileInputStream _smbFileInputStream = new SmbFileInputStream(smbFile);
            BufferedInputStream in = new BufferedInputStream((InputStream)_smbFileInputStream);
            return in;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void uploadOneFile(final SmbFile smbFile, LocalLoader ll) {
        try (BufferedOutputStream out = new Functions.Function0<BufferedOutputStream>(){

            public BufferedOutputStream apply() {
                try {
                    SmbFileOutputStream _smbFileOutputStream = new SmbFileOutputStream(smbFile);
                    return new BufferedOutputStream((OutputStream)_smbFileOutputStream);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        }.apply();){
            if (ll != null) {
                ll.loader(out);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static interface LocalLoader {
        public void loader(OutputStream var1);
    }
}

