/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import cool.taomu.guice.ann.Binders;
import cool.taomu.guice.util.asm.CreateClass;
import cool.taomu.guice.util.asm.CreateMethod;
import cool.taomu.guice.util.asm.entity.ClassEntity;
import cool.taomu.guice.util.asm.entity.MethodEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure2;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class TaomuGuice {
  private static final Logger LOG = LoggerFactory.getLogger(TaomuGuice.class);
  
  public static Injector entry(final Class<?>... zlasses) {
    final Function1<Class<?>, com.google.inject.Module> _function = (Class<?> it) -> {
      return TaomuGuice.create(it);
    };
    return Guice.createInjector(ListExtensions.<Class<?>, com.google.inject.Module>map(((List<Class<?>>)Conversions.doWrapArray(zlasses)), _function));
  }
  
  /**
   * @PRARM isDebug
   */
  public static Injector entry(final boolean isDebug, final Class<?>... zlasses) {
    final Function1<Class<?>, com.google.inject.Module> _function = (Class<?> it) -> {
      return TaomuGuice.create(it, isDebug);
    };
    return Guice.createInjector(ListExtensions.<Class<?>, com.google.inject.Module>map(((List<Class<?>>)Conversions.doWrapArray(zlasses)), _function));
  }
  
  public static com.google.inject.Module create(final Class<?> zlass) {
    return TaomuGuice.create(zlass, false);
  }
  
  public static com.google.inject.Module create(final Class<?> zlass, final boolean isDebug) {
    try {
      Binders binders = zlass.<Binders>getAnnotation(Binders.class);
      if ((binders != null)) {
        String name = UUID.randomUUID().toString().replace("-", "");
        String moduleName = IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("Taomu", name, "Module")), "");
        ClassEntity classEntity = new ClassEntity("cool.taomu.guice", moduleName);
        classEntity.setSuperclass(Type.getType(AbstractModule.class).getInternalName());
        CreateClass cc = CreateClass.Class(classEntity, Opcodes.V1_8, isDebug);
        cc.constructor(AbstractModule.class.getConstructors());
        MethodEntity methodEntity = new MethodEntity("void configure()");
        MethodEntity binder = new MethodEntity("com/google/inject/Binder binder()", true);
        final MethodEntity bind = new MethodEntity("com/google/inject/Binder", 
          "com/google/inject/binder/AnnotatedBindingBuilder bind(java/lang/Class)", true);
        final MethodEntity to = new MethodEntity("com/google/inject/binder/AnnotatedBindingBuilder", 
          "com/google/inject/binder/ScopedBindingBuilder to(java/lang/Class)", true);
        final MethodEntity in = new MethodEntity("com/google/inject/binder/ScopedBindingBuilder", 
          "void in(com/google/inject/Scope)", true);
        final CreateMethod cm = cc.method(methodEntity).This().invokeVirtual(binder).store("binder", Binder.class);
        Binders.Binder[] binds = binders.value();
        final Binders.Binder[] _converted_binds = (Binders.Binder[])binds;
        final Consumer<Binders.Binder> _function = (Binders.Binder it) -> {
          boolean _equals = it.bind().equals(Void.class);
          boolean _not = (!_equals);
          if (_not) {
            cm.load("binder").ldc(Type.getType(it.bind())).invokeInterface(bind);
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(it.named());
            boolean _not_1 = (!_isNullOrEmpty);
            if (_not_1) {
              cm.ldc(it.named());
              MethodEntity _methodEntity = new MethodEntity("com/google/inject/name/Names", 
                "com/google/inject/name/Named named(java/lang/String)", true);
              cm.invokeStatic(_methodEntity);
              MethodEntity _methodEntity_1 = new MethodEntity("com/google/inject/binder/AnnotatedBindingBuilder", 
                "com/google/inject/binder/LinkedBindingBuilder annotatedWith(java/lang/annotation/Annotation)", 
                true);
              cm.invokeInterface(_methodEntity_1);
            }
            boolean _equals_1 = it.to().equals(Void.class);
            boolean _not_2 = (!_equals_1);
            if (_not_2) {
              cm.ldc(Type.getType(it.to())).invokeInterface(to);
              Binders.Binder.Scope _in = it.in();
              boolean _tripleNotEquals = (_in != Binders.Binder.Scope.None);
              if (_tripleNotEquals) {
                boolean _equals_2 = it.in().equals(Binders.Binder.Scope.SINGLETON);
                if (_equals_2) {
                  cm.getStatic("com/google/inject/Scopes", "SINGLETON", "Lcom/google/inject/Scope;");
                } else {
                  boolean _equals_3 = it.in().equals(Binders.Binder.Scope.NO_SCOPE);
                  if (_equals_3) {
                    cm.getStatic("com/google/inject/Scopes", "NO_SCOPE", "Lcom/google/inject/Scope;");
                  }
                }
                cm.invokeInterface(in);
              } else {
                cm.pop();
              }
            } else {
              boolean _equals_4 = it.instance().equals(Void.class);
              boolean _not_3 = (!_equals_4);
              if (_not_3) {
                cm.store("instance", Binder.class);
                cm.NEW(it.instance());
                cm.dup();
                final ArrayList<String> vinit = CollectionLiterals.<String>newArrayList(new String[] { "void", " <init>(" });
                final Procedure2<Class<?>, Integer> _function_1 = (Class<?> targs, Integer index) -> {
                  boolean _equals_5 = targs.equals(String.class);
                  if (_equals_5) {
                    cm.ldc(it.args()[(index).intValue()]);
                    vinit.add("String,");
                  } else {
                    boolean _equals_6 = targs.equals(char.class);
                    if (_equals_6) {
                      String v = it.args()[(index).intValue()];
                      boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty(v);
                      boolean _not_4 = (!_isNullOrEmpty_1);
                      if (_not_4) {
                        char vv = v.charAt(0);
                        cm.ldc(Character.valueOf(vv));
                      }
                      vinit.add("char,");
                    } else {
                      boolean _equals_7 = targs.equals(int.class);
                      if (_equals_7) {
                        cm.ldc(Integer.valueOf(Integer.parseInt(it.args()[(index).intValue()])));
                        vinit.add("int,");
                      } else {
                        boolean _equals_8 = targs.equals(short.class);
                        if (_equals_8) {
                          cm.ldc(Short.valueOf(Short.parseShort(it.args()[(index).intValue()])));
                          vinit.add("short,");
                        } else {
                          boolean _equals_9 = targs.equals(long.class);
                          if (_equals_9) {
                            cm.ldc(Long.valueOf(Long.parseLong(it.args()[(index).intValue()])));
                            vinit.add("long,");
                          } else {
                            boolean _equals_10 = targs.equals(double.class);
                            if (_equals_10) {
                              cm.ldc(Double.valueOf(Double.parseDouble(it.args()[(index).intValue()])));
                              vinit.add("double,");
                            } else {
                              boolean _equals_11 = targs.equals(float.class);
                              if (_equals_11) {
                                cm.ldc(Float.valueOf(Float.parseFloat(it.args()[(index).intValue()])));
                                vinit.add("float,");
                              } else {
                                boolean _equals_12 = targs.equals(boolean.class);
                                if (_equals_12) {
                                  cm.ldc(Boolean.valueOf(Boolean.parseBoolean(it.args()[(index).intValue()])));
                                  vinit.add("boolean,");
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                };
                IterableExtensions.<Class<?>>forEach(IterableExtensions.<Class<?>>filterNull(((Iterable<Class<?>>)Conversions.doWrapArray(it.typeArgs()))), _function_1);
                String _join = IterableExtensions.join(((Iterable<?>)Conversions.doWrapArray(IterableExtensions.join(vinit, "").split(","))), ",");
                String init = (_join + ")");
                String _name = it.instance().getName();
                MethodEntity _methodEntity_2 = new MethodEntity(_name, init);
                cm.invokeSpecial(_methodEntity_2);
                cm.store(it.instance().getName(), it.instance());
                cm.load("instance");
                cm.load(it.instance().getName());
                MethodEntity _methodEntity_3 = new MethodEntity("com/google/inject/binder/AnnotatedBindingBuilder", 
                  "void toInstance(java/lang/Object)", true);
                cm.invokeInterface(_methodEntity_3);
              }
            }
          }
        };
        ((List<Binders.Binder>)Conversions.doWrapArray(_converted_binds)).forEach(_function);
        cm.returnValue().endMethod();
        cc.end();
        Object _newInstance = cc.loadClass(IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("cool.taomu.guice", moduleName)), ".")).newInstance();
        return ((com.google.inject.Module) _newInstance);
      }
      return null;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
