/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.guice.ann;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@SuppressWarnings("all")
public @interface Binders {
  public @interface Binder {
    public enum Scope {
      None,
      
      NO_SCOPE,
      
      SINGLETON;
    }
    public Class<?> bind();
    public String named() default "";
    public Class<?> to() default Void.class;
    public Class<?> instance() default Void.class;
    public Binders.Binder.Scope in() default Binders.Binder.Scope.None;
    public Class<?>[] typeArgs() default {};
    public String[] args() default {};
  }
  public Binders.Binder[] value();
}
