/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.guice.util.asm.entity;

import java.util.Collections;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@SuppressWarnings("all")
public class ClassEntity {
  private String packageName;
  
  private String className;
  
  private String superclass = "java/lang/Object";
  
  private String[] interfaces;
  
  public ClassEntity(final String packageName, final String className) {
    this.packageName = packageName;
    this.className = className;
  }
  
  public String getFullName() {
    return IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(this.packageName, this.className)), ".").replace(".", "/");
  }
  
  @Pure
  public String getPackageName() {
    return this.packageName;
  }
  
  public void setPackageName(final String packageName) {
    this.packageName = packageName;
  }
  
  @Pure
  public String getClassName() {
    return this.className;
  }
  
  public void setClassName(final String className) {
    this.className = className;
  }
  
  @Pure
  public String getSuperclass() {
    return this.superclass;
  }
  
  public void setSuperclass(final String superclass) {
    this.superclass = superclass;
  }
  
  @Pure
  public String[] getInterfaces() {
    return this.interfaces;
  }
  
  public void setInterfaces(final String[] interfaces) {
    this.interfaces = interfaces;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("packageName", this.packageName);
    b.add("className", this.className);
    b.add("superclass", this.superclass);
    b.add("interfaces", this.interfaces);
    return b.toString();
  }
}
