/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.mqtt.broker;

import cool.taomu.mqtt.broker.entity.MqttBrokerEntity;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class MQTTBroker {
  private static final Logger LOG = LoggerFactory.getLogger(MQTTBroker.class);
  
  private NioEventLoopGroup selectGroup;
  
  private NioEventLoopGroup ioGroup;
  
  private MqttBrokerEntity config;
  
  private final int coreNumber = Runtime.getRuntime().availableProcessors();
  
  public MQTTBroker(final MqttBrokerEntity config) {
    NioEventLoopGroup _nioEventLoopGroup = new NioEventLoopGroup(this.coreNumber);
    this.selectGroup = _nioEventLoopGroup;
    NioEventLoopGroup _nioEventLoopGroup_1 = new NioEventLoopGroup((this.coreNumber * 2));
    this.ioGroup = _nioEventLoopGroup_1;
    this.config = config;
  }
  
  public ChannelFuture startTcpServer() {
    try {
      ChannelFuture _xblockexpression = null;
      {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        final ServerBootstrap bootstrap = serverBootstrap.group(this.selectGroup, this.ioGroup);
        ServerBootstrap channel = bootstrap.channel(NioServerSocketChannel.class);
        channel.<Integer>option(ChannelOption.SO_BACKLOG, Integer.valueOf(1024)).<Boolean>childOption(ChannelOption.TCP_NODELAY, Boolean.valueOf(false)).<Boolean>option(
          ChannelOption.SO_REUSEADDR, Boolean.valueOf(true)).<Boolean>childOption(ChannelOption.SO_KEEPALIVE, Boolean.valueOf(false));
        channel.childHandler(new ChannelInitializer<SocketChannel>() {
          @Override
          protected void initChannel(final SocketChannel ch) throws Exception {
            ChannelPipeline pipeline = ch.pipeline();
            boolean _isUseSsl = MQTTBroker.this.config.isUseSsl();
            if (_isUseSsl) {
              pipeline.addLast("ssl", MQTTSslHandler.build(ch, MQTTBroker.this.config.getSsl()));
            }
            IdleStateHandler _idleStateHandler = new IdleStateHandler(60, 0, 0);
            pipeline.addLast("idleStateHandler", _idleStateHandler);
            pipeline.addLast("mqttEncoder", MqttEncoder.INSTANCE);
            MqttDecoder _mqttDecoder = new MqttDecoder(Integer.MAX_VALUE);
            pipeline.addLast("mqttDecoder", _mqttDecoder);
            MQTTHandler _mQTTHandler = new MQTTHandler();
            pipeline.addLast("nettyMqttHandler", _mQTTHandler);
          }
        });
        Runtime _runtime = Runtime.getRuntime();
        _runtime.addShutdownHook(new Thread() {
          @Override
          public void run() {
            MQTTBroker.this.selectGroup.shutdownGracefully();
            MQTTBroker.this.ioGroup.shutdownGracefully();
          }
        });
        MQTTBroker.LOG.info("启动MQTT代理服务 ip: {} port: {}", this.config.getHostname(), this.config.getPort());
        _xblockexpression = bootstrap.bind(this.config.getHostname(), (this.config.getPort()).intValue()).sync();
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
