/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.mqtt.broker;

import cool.taomu.mqtt.broker.entity.MqttBrokerEntity;
import cool.taomu.mqtt.broker.entity.SslEntity;
import cool.taomu.util.YamlUtils;

@SuppressWarnings("all")
public class MqttBrokerConfigure {
  public MqttBrokerConfigure() {
  }
  
  public MqttBrokerEntity read() {
    return YamlUtils.<MqttBrokerEntity>read("./config/broker.yml", MqttBrokerEntity.class);
  }
  
  public void write(final Object obj) {
    YamlUtils.write("./config/broker.yml", obj);
  }
  
  public static void main(final String[] args) {
    MqttBrokerConfigure a = new MqttBrokerConfigure();
    MqttBrokerEntity b = new MqttBrokerEntity();
    b.setAnonymous(false);
    b.setHostname("127.0.0.1");
    SslEntity _sslEntity = new SslEntity();
    b.setSsl(_sslEntity);
    a.write(b);
  }
}
