/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.mqtt.broker.factory;

import cool.taomu.mqtt.broker.entity.MessageEntity;
import cool.taomu.mqtt.broker.utils.MqttUtils;
import cool.taomu.mqtt.broker.utils.impl.DataStorage;
import cool.taomu.storage.inter.IStorage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class PubCompRequest implements IProcess {
  private static final Logger LOG = LoggerFactory.getLogger(PubCompRequest.class);
  
  private IStorage cache = new DataStorage();
  
  @Override
  public void request(final ChannelHandlerContext ctx, final MqttMessage mqttMessage) {
    String clientId = MqttUtils.getClientId(ctx.channel());
    PubCompRequest.LOG.info(("执行了MQTT PubComp 命令 : " + clientId));
    int msgId = MqttUtils.getMessageId(mqttMessage);
    Serializable _get = this.cache.get("mqtt-qos2-message", IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(clientId, Integer.valueOf(msgId))), "#"));
    HashSet<?> qos2 = ((HashSet<?>) _get);
    for (final Object q : qos2) {
      {
        MessageEntity msg = ((MessageEntity) q);
        MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.PUBCOMP, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader _from = MqttMessageIdVariableHeader.from(msgId);
        MqttMessage _mqttMessage = new MqttMessage(header, _from);
        msg.getSenderChannel().writeAndFlush(_mqttMessage);
        qos2.remove(msg);
        this.cache.put("mqtt-qos2-message", IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(clientId, Integer.valueOf(msgId))), "#"), qos2);
      }
    }
  }
}
