/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.mqtt.broker.factory;

import cool.taomu.mqtt.broker.entity.MessageEntity;
import cool.taomu.mqtt.broker.utils.MqttUtils;
import cool.taomu.mqtt.broker.utils.impl.DataStorage;
import cool.taomu.storage.inter.IStorage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class PubRelRequest implements IProcess {
  private final Logger LOG = LoggerFactory.getLogger(PubRelRequest.class);
  
  private IStorage cache = new DataStorage();
  
  @Override
  public void request(final ChannelHandlerContext ctx, final MqttMessage mqttMessage) {
    String clientId = MqttUtils.getClientId(ctx.channel());
    this.LOG.info(("执行了MQTT PubRel 命令 : " + clientId));
    Object _variableHeader = mqttMessage.variableHeader();
    MqttMessageIdVariableHeader idVariableHeader = ((MqttMessageIdVariableHeader) _variableHeader);
    int msgId = idVariableHeader.messageId();
    Serializable _get = this.cache.get("mqtt-qos2-message", IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(clientId, Integer.valueOf(msgId))), "#"));
    HashSet<?> qos2 = ((HashSet<?>) _get);
    for (final Object q : qos2) {
      {
        MessageEntity msg = ((MessageEntity) q);
        MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.PUBREL, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader varHeader = MqttMessageIdVariableHeader.from(msgId);
        MqttMessage _mqttMessage = new MqttMessage(header, varHeader);
        msg.getSenderChannel().writeAndFlush(_mqttMessage);
        this.cache.remove("mqtt-qos2-message", IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(clientId, Integer.valueOf(msgId))), "#"));
        msg.setSenderChannel(ctx.channel());
        String senderId = msg.getSenderId();
        msg.setSenderId(clientId);
        this.cache.put("mqtt-qos2-message", IterableExtensions.join(Collections.<Object>unmodifiableList(CollectionLiterals.<Object>newArrayList(senderId, Integer.valueOf(msgId))), "#"), msg);
      }
    }
  }
}
