/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.mqtt.broker.impl;

import cool.taomu.mqtt.broker.utils.inter.IObserver;
import java.util.function.Consumer;

@SuppressWarnings("all")
public class PublishObservable extends AObservable<IObserver> {
  private static final PublishObservable instance = new PublishObservable();
  
  private PublishObservable() {
  }
  
  public static PublishObservable getInstance() {
    return PublishObservable.instance;
  }
  
  @Override
  public void publish(final Object arg, final Object... args) {
    final Consumer<IObserver> _function = (IObserver it) -> {
      final Runnable _function_1 = () -> {
        it.publish(this, arg);
      };
      AObservable.exec.submit(_function_1);
    };
    this.providers.values().forEach(_function);
  }
}
