/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.mqtt.broker;

import cool.taomu.mqtt.broker.MQTTHandler;
import cool.taomu.mqtt.broker.MQTTSslHandler;
import cool.taomu.mqtt.broker.entity.MqttBrokerEntity;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTBroker {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTBroker.class);
    private NioEventLoopGroup selectGroup;
    private NioEventLoopGroup ioGroup;
    private MqttBrokerEntity config;
    private final int coreNumber = Runtime.getRuntime().availableProcessors();

    public MQTTBroker(MqttBrokerEntity config) {
        NioEventLoopGroup _nioEventLoopGroup_1;
        NioEventLoopGroup _nioEventLoopGroup;
        this.selectGroup = _nioEventLoopGroup = new NioEventLoopGroup(this.coreNumber);
        this.ioGroup = _nioEventLoopGroup_1 = new NioEventLoopGroup(this.coreNumber * 2);
        this.config = config;
    }

    public ChannelFuture startTcpServer() {
        try {
            ChannelFuture _xblockexpression = null;
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            ServerBootstrap bootstrap = serverBootstrap.group((EventLoopGroup)this.selectGroup, (EventLoopGroup)this.ioGroup);
            ServerBootstrap channel = (ServerBootstrap)bootstrap.channel(NioServerSocketChannel.class);
            ((ServerBootstrap)((ServerBootstrap)channel.option(ChannelOption.SO_BACKLOG, (Object)1024)).childOption(ChannelOption.TCP_NODELAY, (Object)false).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)false);
            channel.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    boolean _isUseSsl = MQTTBroker.this.config.isUseSsl();
                    if (_isUseSsl) {
                        pipeline.addLast("ssl", (ChannelHandler)MQTTSslHandler.build(ch, MQTTBroker.this.config.getSsl()));
                    }
                    IdleStateHandler _idleStateHandler = new IdleStateHandler(60, 0, 0);
                    pipeline.addLast("idleStateHandler", (ChannelHandler)_idleStateHandler);
                    pipeline.addLast("mqttEncoder", (ChannelHandler)MqttEncoder.INSTANCE);
                    MqttDecoder _mqttDecoder = new MqttDecoder(Integer.MAX_VALUE);
                    pipeline.addLast("mqttDecoder", (ChannelHandler)_mqttDecoder);
                    MQTTHandler _mQTTHandler = new MQTTHandler();
                    pipeline.addLast("nettyMqttHandler", (ChannelHandler)_mQTTHandler);
                }
            });
            Runtime _runtime = Runtime.getRuntime();
            _runtime.addShutdownHook(new Thread(){

                @Override
                public void run() {
                    MQTTBroker.this.selectGroup.shutdownGracefully();
                    MQTTBroker.this.ioGroup.shutdownGracefully();
                }
            });
            LOG.info("\u542f\u52a8MQTT\u4ee3\u7406\u670d\u52a1 ip: {} port: {}", (Object)this.config.getHostname(), (Object)this.config.getPort());
            _xblockexpression = bootstrap.bind(this.config.getHostname(), this.config.getPort().intValue()).sync();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

