/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.mqtt.mqttv3;

import cool.taomu.mqtt.mqttv3.Topics;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.PARAMETER})
@Repeatable(value=Topics.class)
public @interface Topic {
    public MessageType messageType() default MessageType.SUBSCRIBER;

    public String[] value();

    public String clientId() default "uuid";

    public QoS[] qos() default {QoS.AT_LEAST_ONCE};

    public int keepAlive() default 20;

    public int timeout() default 10;

    public boolean retain() default true;

    public boolean cleanSession() default false;

    public boolean isSsl() default false;

    public static enum MessageType {
        SUBSCRIBER,
        SENDER;

    }

    public static enum QoS {
        AT_MOST_ONCE,
        AT_LEAST_ONCE,
        EXACTLY_ONCE;

    }
}

