/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.mqtt.mqttv3;

import com.google.common.base.Objects;
import cool.taomu.crypto.Base64;
import cool.taomu.mqtt.mqttv3.MqttCallbackExtend;
import cool.taomu.mqtt.mqttv3.MqttV3Service;
import cool.taomu.mqtt.mqttv3.Topic;
import cool.taomu.mqtt.mqttv3.Topics;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Accessors
public abstract class MqttCallback
extends MqttCallbackExtend
implements org.eclipse.paho.client.mqttv3.MqttCallback {
    private static final Logger LOG = LoggerFactory.getLogger(MqttCallback.class);
    private MqttClient client;
    private MqttConnectOptions options;
    private String host;
    private int port;
    private String password;
    private String username;

    public void setClient(MqttClient client) {
        this.client = client;
    }

    public void setOptions(MqttConnectOptions options) {
        this.options = options;
    }

    public void connectionLost(Throwable cause) {
        LOG.debug("\u8fde\u63a5\u4e22\u5931", cause);
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        Consumer<String> _function = it -> LOG.debug("Client deliveryComplete : {}", it);
        ((List)Conversions.doWrapArray((Object)token.getTopics())).forEach(_function);
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        byte[] _payload = message.getPayload();
        byte[] base64 = new Base64(_payload).decode();
        byte[] payload = this.message(topic, base64);
        if (payload != null) {
            Topics topics = this.getClass().getAnnotation(Topics.class);
            Functions.Function1 _function = it -> {
                Topic.MessageType _messageType = it.messageType();
                return Objects.equal((Object)((Object)_messageType), (Object)((Object)Topic.MessageType.SENDER));
            };
            Consumer<Topic> _function_1 = it -> MqttV3Service.sender(it, this.host, this.port, this.username, this.password, payload);
            IterableExtensions.filterNull((Iterable)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)topics.value())), (Functions.Function1)_function)).forEach(_function_1);
        }
    }

    public abstract byte[] message(String var1, byte[] var2);

    @Pure
    public MqttClient getClient() {
        return this.client;
    }

    @Pure
    public MqttConnectOptions getOptions() {
        return this.options;
    }

    @Pure
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Pure
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Pure
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Pure
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

