/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.mqtt.broker.factory;

import cool.taomu.mqtt.broker.entity.ClientSessionEntity;
import cool.taomu.mqtt.broker.entity.MessageEntity;
import cool.taomu.mqtt.broker.impl.PublishObservable;
import cool.taomu.mqtt.broker.utils.MqttUtils;
import cool.taomu.mqtt.broker.utils.impl.DataStorage;
import cool.taomu.mqtt.broker.utils.inter.IObservable;
import cool.taomu.mqtt.broker.utils.inter.IObserver;
import cool.taomu.storage.inter.IStorage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class DisconnectRequest implements IProcess {
  private static final Logger LOG = LoggerFactory.getLogger(DisconnectRequest.class);
  
  private static final IObservable<IObserver> observable = PublishObservable.getInstance();
  
  private final IStorage cache = new DataStorage();
  
  @Override
  public void request(final ChannelHandlerContext ctx, final MqttMessage mqttMessage) {
    DisconnectRequest.LOG.info("执行了MQTT Disconnect 命令");
    String clientId = MqttUtils.getClientId(ctx.channel());
    Serializable _get = this.cache.get("mqtt-session", clientId);
    ClientSessionEntity clientSession = ((ClientSessionEntity) _get);
    this.pushWill(clientId);
    boolean _isCleanStatus = clientSession.isCleanStatus();
    if (_isCleanStatus) {
      this.cache.remove("mqtt-session", clientId);
    }
    ctx.close();
  }
  
  public void pushWill(final String clientId) {
    Serializable _get = this.cache.get("mqtt-will", clientId);
    MessageEntity will = ((MessageEntity) _get);
    if ((will != null)) {
      DisconnectRequest.observable.publish(will);
    }
  }
}
