/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.mqtt.broker.factory;

import cool.taomu.mqtt.broker.impl.PublishObservable;
import cool.taomu.mqtt.broker.utils.MqttUtils;
import cool.taomu.mqtt.broker.utils.inter.IObservable;
import cool.taomu.mqtt.broker.utils.inter.IObserver;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class UnSubscribeRequest implements IProcess {
  private static final Logger LOG = LoggerFactory.getLogger(UnSubscribeRequest.class);
  
  private static final IObservable<IObserver> observable = PublishObservable.getInstance();
  
  @Override
  public void request(final ChannelHandlerContext ctx, final MqttMessage mqttMessage) {
    MqttUnsubscribeMessage message = ((MqttUnsubscribeMessage) mqttMessage);
    int messageId = message.variableHeader().messageId();
    List<String> topics = message.payload().topics();
    final String clientId = MqttUtils.getClientId(ctx.channel());
    final Consumer<String> _function = (String it) -> {
      UnSubscribeRequest.LOG.info("unsubscribe clientId {} topics {}", clientId, it);
      UnSubscribeRequest.observable.unregister(IterableExtensions.join(Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(clientId, it)), "#"));
    };
    topics.forEach(_function);
    MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.UNSUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
    MqttMessageIdVariableHeader varHeader = MqttMessageIdVariableHeader.from(messageId);
    MqttUnsubAckMessage _mqttUnsubAckMessage = new MqttUnsubAckMessage(header, varHeader);
    ctx.writeAndFlush(_mqttUnsubAckMessage);
  }
}
