/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.mqtt.broker.factory;

import cool.taomu.mqtt.broker.factory.IProcess;
import cool.taomu.mqtt.broker.impl.PublishObservable;
import cool.taomu.mqtt.broker.utils.MqttUtils;
import cool.taomu.mqtt.broker.utils.inter.IObservable;
import cool.taomu.mqtt.broker.utils.inter.IObserver;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnSubscribeRequest
implements IProcess {
    private static final Logger LOG = LoggerFactory.getLogger(UnSubscribeRequest.class);
    private static final IObservable<IObserver> observable = PublishObservable.getInstance();

    @Override
    public void request(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        MqttUnsubscribeMessage message = (MqttUnsubscribeMessage)mqttMessage;
        int messageId = message.variableHeader().messageId();
        List topics = message.payload().topics();
        String clientId = MqttUtils.getClientId(ctx.channel());
        Consumer<String> _function = it -> {
            LOG.info("unsubscribe clientId {} topics {}", (Object)clientId, it);
            observable.unregister(IterableExtensions.join(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{clientId, it})), (CharSequence)"#"));
        };
        topics.forEach(_function);
        MqttFixedHeader header = new MqttFixedHeader(MqttMessageType.UNSUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader varHeader = MqttMessageIdVariableHeader.from((int)messageId);
        MqttUnsubAckMessage _mqttUnsubAckMessage = new MqttUnsubAckMessage(header, varHeader);
        ctx.writeAndFlush((Object)_mqttUnsubAckMessage);
    }
}

