/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.mqtt.mqttv3;

import java.util.concurrent.TimeUnit;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttCallbackExtend {
    static final Logger LOG = LoggerFactory.getLogger(MqttCallbackExtend.class);

    protected void reconnect(MqttClient client, MqttConnectOptions options) {
        try {
            client.reconnect();
            while (true) {
                try {
                    do {
                        TimeUnit.SECONDS.sleep(1L);
                        client.connect(options);
                    } while (!client.isConnected());
                }
                catch (InterruptedException | MqttException e) {
                    LOG.info("clientId : {} \u5c1d\u8bd5\u91cd\u65b0\u8fde\u63a5", (Object)client.getClientId(), (Object)e);
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
        catch (MqttException e1) {
            LOG.info("MqttExecption : ", (Throwable)e1);
        }
    }
}

