/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.mqtt.mqttv3;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.TYPE, ElementType.PARAMETER })
@Repeatable(Topics.class)
@SuppressWarnings("all")
public @interface Topic {
  public enum QoS {
    AT_MOST_ONCE,
    
    AT_LEAST_ONCE,
    
    EXACTLY_ONCE;
  }
  public enum MessageType {
    SUBSCRIBER,
    
    SENDER;
  }
  public Topic.MessageType messageType() default Topic.MessageType.SUBSCRIBER;
  public String[] value();
  public String clientId() default "uuid";
  public Topic.QoS[] qos() default { Topic.QoS.AT_LEAST_ONCE };
  public int keepAlive() default 20;
  public int timeout() default 10;
  public boolean retain() default true;
  public boolean cleanSession() default false;
  public boolean isSsl() default false;
}
