/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.mqtt.mqttv3;

import com.google.common.base.Objects;
import com.google.gson.Gson;
import cool.taomu.crypto.Base64;
import cool.taomu.mqtt.mqttv3.MqttCallback;
import cool.taomu.mqtt.mqttv3.Topic;
import cool.taomu.mqtt.mqttv3.Topics;
import cool.taomu.mqtt.mqttv3.Will;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttV3Service {
    private static final Logger LOG = LoggerFactory.getLogger(MqttV3Service.class);

    public static void subscriber(ExecutorService es, String host, int port, String username, String password, Class<? extends MqttCallback> ... callbacks) {
        Consumer<Class> _function = it -> {
            Runnable _function_1 = () -> {
                Topics topics = it.getAnnotation(Topics.class);
                if (topics != null) {
                    Functions.Function1 _function_2 = it_1 -> {
                        Topic.MessageType _messageType = it_1.messageType();
                        return Objects.equal((Object)((Object)_messageType), (Object)((Object)Topic.MessageType.SUBSCRIBER));
                    };
                    Consumer<Topic> _function_3 = topic -> MqttV3Service.subscriber(topic, host, port, username, password, (Class<? extends MqttCallback>)it);
                    IterableExtensions.filter((Iterable)IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray((Object)topics.value()))), (Functions.Function1)_function_2).forEach(_function_3);
                } else {
                    Topic topic2 = it.getAnnotation(Topic.class);
                    MqttV3Service.subscriber(topic2, host, port, username, password, (Class<? extends MqttCallback>)it);
                }
            };
            es.execute(_function_1);
        };
        IterableExtensions.filterNull((Iterable)((Iterable)Conversions.doWrapArray(callbacks))).forEach(_function);
    }

    public static void sender(Topic topic, String host, int port, String username, String password, byte[] payload) {
        Topic.MessageType _messageType = topic.messageType();
        boolean _equals = Objects.equal((Object)((Object)_messageType), (Object)((Object)Topic.MessageType.SENDER));
        if (_equals) {
            MqttV3Service.sender(topic.value()[0], topic.timeout(), topic.isSsl(), topic.clientId(), topic.qos()[0].ordinal(), topic.retain(), host, port, username, password, payload);
        }
    }

    public static void sender(String topic, String host, int port, String username, String password, byte[] payload) {
        MqttV3Service.sender(topic, 6000, false, UUID.randomUUID().toString(), 1, true, host, port, username, password, payload);
    }

    public static void sender(String topic, int timeout, boolean isSsl, String clientId, int qos, boolean retain, String host, int port, String username, String password, byte[] payload) {
        try (MemoryPersistence memoryPersistence = new MemoryPersistence();){
            MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
            mqttConnectOptions.setMqttVersion(4);
            mqttConnectOptions.setCleanSession(true);
            if (username != null) {
                mqttConnectOptions.setUserName(username);
                mqttConnectOptions.setPassword(password.toCharArray());
            }
            mqttConnectOptions.setConnectionTimeout(timeout);
            mqttConnectOptions.setKeepAliveInterval(20);
            String _xifexpression = null;
            _xifexpression = isSsl ? "ssl" : "tcp";
            String _format = String.format("%s://%s:%d", _xifexpression, host, port);
            MqttClient mqttClient = new MqttClient(_format, clientId, (MqttClientPersistence)memoryPersistence);
            mqttClient.connect(mqttConnectOptions);
            byte[] _encode = new Base64(payload).encode();
            MqttMessage mqttMessage = new MqttMessage(_encode);
            mqttMessage.setQos(qos);
            mqttMessage.setRetained(retain);
            mqttClient.publish(topic, mqttMessage);
            LOG.debug("clientId: {} \u53d1\u9001\u6210\u529f", (Object)clientId);
            mqttClient.disconnect();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception ex = (Exception)_t;
                LOG.info("mqtt \u5f02\u5e38:", (Throwable)ex);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private static void subscriber(final Topic topic, String host, int port, String username, String password, Class<? extends MqttCallback> callback) {
        try {
            Topic.MessageType _messageType = topic.messageType();
            boolean _equals = Objects.equal((Object)((Object)_messageType), (Object)((Object)Topic.MessageType.SUBSCRIBER));
            if (_equals) {
                Will will = callback.getAnnotation(Will.class);
                if (topic != null) {
                    boolean _not;
                    String _json = new Gson().toJson((Object)topic.value());
                    String _plus = "Topic : " + _json;
                    LOG.info(_plus);
                    final MemoryPersistence memoryPersistence = new MemoryPersistence();
                    MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
                    mqttConnectOptions.setMqttVersion(4);
                    mqttConnectOptions.setCleanSession(topic.cleanSession());
                    if (username != null && !username.trim().equals("")) {
                        mqttConnectOptions.setUserName(username);
                        mqttConnectOptions.setPassword(password.toCharArray());
                    }
                    mqttConnectOptions.setConnectionTimeout(topic.timeout());
                    mqttConnectOptions.setKeepAliveInterval(topic.keepAlive());
                    if (will != null) {
                        mqttConnectOptions.setWill(will.topic(), will.message().getBytes("UTF-8"), will.qos(), will.retain());
                    }
                    String _xifexpression = null;
                    boolean _isSsl = topic.isSsl();
                    _xifexpression = _isSsl ? "ssl" : "tcp";
                    String broker = String.format("%s://%s:%d", _xifexpression, host, port);
                    String uuid = UUID.randomUUID().toString();
                    boolean _equals_1 = topic.clientId().equals("uuid");
                    boolean bl = _not = !_equals_1;
                    if (_not) {
                        uuid = topic.clientId();
                    }
                    final MqttClient mqttClient = new MqttClient(broker, uuid, (MqttClientPersistence)memoryPersistence);
                    MqttCallback mc = callback.newInstance();
                    mc.setClient(mqttClient);
                    mc.setOptions(mqttConnectOptions);
                    mc.setHost(host);
                    mc.setPort(port);
                    if (username != null && !username.trim().equals("")) {
                        mc.setUsername(username);
                        mc.setPassword(password);
                    }
                    mqttClient.setCallback((org.eclipse.paho.client.mqttv3.MqttCallback)mc);
                    mqttClient.connect(mqttConnectOptions);
                    ArrayList<Integer> qoss = new ArrayList<Integer>();
                    Functions.Function1 _function = it -> it.ordinal();
                    qoss.addAll(ListExtensions.map((List)((List)Conversions.doWrapArray((Object)topic.qos())), (Functions.Function1)_function));
                    for (int i = 0; qoss.size() < ((List)Conversions.doWrapArray((Object)topic.value())).size() && i < ((List)Conversions.doWrapArray((Object)topic.value())).size() - qoss.size(); ++i) {
                        qoss.add(Topic.QoS.AT_MOST_ONCE.ordinal());
                    }
                    ArrayList<Integer> _converted_qoss = qoss;
                    mqttClient.subscribe(topic.value(), (int[])Conversions.unwrapArray(_converted_qoss, Integer.TYPE));
                    Runtime _runtime = Runtime.getRuntime();
                    _runtime.addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            try {
                                mqttClient.unsubscribe(topic.value());
                                mqttClient.disconnect();
                                memoryPersistence.close();
                            }
                            catch (Throwable _e) {
                                throw Exceptions.sneakyThrow((Throwable)_e);
                            }
                        }
                    });
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

