/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.mqtt.broker.entity;

import io.netty.handler.codec.mqtt.MqttQoS;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Accessors
@ToString
@SuppressWarnings("all")
public class PublishEntity {
  private MqttQoS qos;
  
  private String topicName;
  
  private Integer messageId;
  
  private byte[] payload;
  
  private Boolean dup;
  
  public PublishEntity(final MqttQoS qos, final String topicName, final Integer messageId, final byte[] payload, final Boolean dup) {
    this.qos = qos;
    this.topicName = topicName;
    this.messageId = messageId;
    this.payload = payload;
    this.dup = dup;
  }
  
  @Pure
  public MqttQoS getQos() {
    return this.qos;
  }
  
  public void setQos(final MqttQoS qos) {
    this.qos = qos;
  }
  
  @Pure
  public String getTopicName() {
    return this.topicName;
  }
  
  public void setTopicName(final String topicName) {
    this.topicName = topicName;
  }
  
  @Pure
  public Integer getMessageId() {
    return this.messageId;
  }
  
  public void setMessageId(final Integer messageId) {
    this.messageId = messageId;
  }
  
  @Pure
  public byte[] getPayload() {
    return this.payload;
  }
  
  public void setPayload(final byte[] payload) {
    this.payload = payload;
  }
  
  @Pure
  public Boolean getDup() {
    return this.dup;
  }
  
  public void setDup(final Boolean dup) {
    this.dup = dup;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("qos", this.qos);
    b.add("topicName", this.topicName);
    b.add("messageId", this.messageId);
    b.add("payload", this.payload);
    b.add("dup", this.dup);
    return b.toString();
  }
}
