/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.mqtt.broker.factory;

import cool.taomu.mqtt.broker.utils.MqttUtils;
import io.netty.channel.Channel;

@SuppressWarnings("all")
public class CheckConnect {
  public static boolean version(final int ver) {
    switch (ver) {
      case 3:
      case 4:
        return true;
      default:
        return false;
    }
  }
  
  public static boolean clientId(final Channel channel, final String clientId) {
    boolean _equals = MqttUtils.getClientId(channel).equals(clientId);
    if (_equals) {
      return true;
    }
    return false;
  }
  
  public static boolean authorized(final String addr, final String clientId) {
    return true;
  }
  
  public static boolean userAuth(final String clientId, final String userName, final byte[] password) {
    return true;
  }
}
