/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.mqtt.broker.utils;

import io.netty.channel.Channel;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;

@SuppressWarnings("all")
public class MqttUtils {
  private static final AttributeKey<String> clientIdAttr = AttributeKey.<String>valueOf("CLIENT_ID");
  
  public static String getRemoteAddr(final Channel channel) {
    if ((null == channel)) {
      return "";
    }
    SocketAddress remote = channel.remoteAddress();
    String _xifexpression = null;
    if ((remote != null)) {
      _xifexpression = remote.toString();
    } else {
      _xifexpression = "";
    }
    final String addr = _xifexpression;
    int _length = addr.length();
    boolean _greaterThan = (_length > 0);
    if (_greaterThan) {
      int index = addr.lastIndexOf("/");
      if ((index >= 0)) {
        return addr.substring((index + 1));
      }
      return addr;
    }
    return "";
  }
  
  public static void setClientId(final Channel channel, final String clientId) {
    channel.<String>attr(MqttUtils.clientIdAttr).set(clientId);
  }
  
  public static String getClientId(final Channel channel) {
    return channel.<String>attr(MqttUtils.clientIdAttr).get();
  }
  
  public static int getMessageId(final MqttMessage mqttMessage) {
    Object _variableHeader = mqttMessage.variableHeader();
    MqttMessageIdVariableHeader varHeader = ((MqttMessageIdVariableHeader) _variableHeader);
    return varHeader.messageId();
  }
  
  public static int getQos(final int qos1, final int qos2) {
    if ((qos1 < qos2)) {
      return qos1;
    }
    return qos2;
  }
  
  public static String session(final String id) {
    return ("mqtt-session-" + id);
  }
  
  public static String qos2Message(final String id) {
    return ("mqtt-qos2-message" + id);
  }
}
