/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.mqtt.broker.utils.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import cool.taomu.storage.inter.IStorage;
import java.io.Serializable;

@SuppressWarnings("all")
public class GuavaCache implements IStorage {
  private static final Cache<String, Serializable> cache = CacheBuilder.newBuilder().<String, Serializable>build();
  
  private static final GuavaCache instance = new GuavaCache();
  
  public static GuavaCache getInstance() {
    return GuavaCache.instance;
  }
  
  @Override
  public int put(final String identifier, final String key, final Serializable value) {
    GuavaCache.cache.put((identifier + key), value);
    return 1;
  }
  
  @Override
  public Serializable get(final String identifier, final String key) {
    return GuavaCache.cache.getIfPresent((identifier + key));
  }
  
  @Override
  public void remove(final String identifier, final String key) {
    GuavaCache.cache.invalidate((identifier + key));
  }
  
  @Override
  public void clear(final String identifier) {
    throw new UnsupportedOperationException("TODO: auto-generated method stub");
  }
}
