/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.mqtt.broker.utils.impl;

import cool.taomu.storage.inter.IStorage;
import java.io.Serializable;

@SuppressWarnings("all")
public class DataStorage implements IStorage {
  private final IStorage storage = new GuavaCache();
  
  @Override
  public int put(final String identifier, final String key, final Serializable value) {
    return this.storage.put(identifier, key, value);
  }
  
  @Override
  public Serializable get(final String identifier, final String key) {
    return this.storage.get(identifier, key);
  }
  
  @Override
  public void remove(final String identifier, final String key) {
    this.storage.remove(identifier, key);
  }
  
  @Override
  public void clear(final String identifier) {
    throw new UnsupportedOperationException("TODO: auto-generated method stub");
  }
}
