/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.mqtt.broker;

import cool.taomu.mqtt.broker.factory.IProcess;
import cool.taomu.mqtt.broker.factory.ProcessFactory;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTHandler
extends ChannelInboundHandlerAdapter {
    private final Logger LOG = LoggerFactory.getLogger(MQTTHandler.class);

    public void channelRead(ChannelHandlerContext ctx, Object obj) {
        MqttMessage mqttMessage = (MqttMessage)obj;
        if (mqttMessage != null && mqttMessage.decoderResult().isSuccess()) {
            MqttMessageType messageType = mqttMessage.fixedHeader().messageType();
            IProcess process = ProcessFactory.instance(messageType);
            this.LOG.debug("\u6536\u5230\u8bf7\u6c42\u7c7b\u578b\uff1a{}", (Object)messageType.name());
            process.request(ctx, mqttMessage);
        } else {
            ctx.close();
        }
    }
}

