/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.mqtt.broker;

import cool.taomu.mqtt.broker.entity.SslEntity;
import cool.taomu.mqtt.broker.utils.SslUtil;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class MQTTSslHandler {
    public static SslHandler build(SocketChannel channel, SslEntity config) {
        try {
            SslEntity sslConfig = config;
            String _keyStoreType = sslConfig.getKeyStoreType();
            SslUtil ssl = new SslUtil(_keyStoreType);
            KeyManagerFactory kmf = ssl.keyManageFactory(sslConfig.getKeyFilePath(), sslConfig.getManagerPwd(), sslConfig.getStorePwd());
            SslContextBuilder contextBuilder = SslContextBuilder.forServer((KeyManagerFactory)kmf);
            SslContext sslContext = contextBuilder.sslProvider(SslProvider.valueOf((String)"JDK")).build();
            SSLEngine sslEngine = sslContext.newEngine(channel.alloc(), channel.remoteAddress().getHostString(), channel.remoteAddress().getPort());
            sslEngine.setUseClientMode(false);
            boolean _isUseClientCA = sslConfig.isUseClientCA();
            if (_isUseClientCA) {
                contextBuilder.clientAuth(ClientAuth.REQUIRE);
                contextBuilder.trustManager(ssl.trustManageFactory());
                sslEngine.setNeedClientAuth(true);
            }
            return new SslHandler(sslEngine);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

