/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.mqtt.broker.factory;

import cool.taomu.mqtt.broker.entity.ClientSessionEntity;
import cool.taomu.mqtt.broker.entity.MessageEntity;
import cool.taomu.mqtt.broker.factory.IProcess;
import cool.taomu.mqtt.broker.impl.PublishObservable;
import cool.taomu.mqtt.broker.utils.MqttUtils;
import cool.taomu.mqtt.broker.utils.impl.DataStorage;
import cool.taomu.mqtt.broker.utils.inter.IObservable;
import cool.taomu.mqtt.broker.utils.inter.IObserver;
import cool.taomu.storage.inter.IStorage;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisconnectRequest
implements IProcess {
    private static final Logger LOG = LoggerFactory.getLogger(DisconnectRequest.class);
    private static final IObservable<IObserver> observable = PublishObservable.getInstance();
    private final IStorage cache = new DataStorage();

    @Override
    public void request(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        LOG.info("\u6267\u884c\u4e86MQTT Disconnect \u547d\u4ee4");
        String clientId = MqttUtils.getClientId(ctx.channel());
        Serializable _get = this.cache.get("mqtt-session", clientId);
        ClientSessionEntity clientSession = (ClientSessionEntity)_get;
        this.pushWill(clientId);
        boolean _isCleanStatus = clientSession.isCleanStatus();
        if (_isCleanStatus) {
            this.cache.remove("mqtt-session", clientId);
        }
        ctx.close();
    }

    public void pushWill(String clientId) {
        Serializable _get = this.cache.get("mqtt-will", clientId);
        MessageEntity will = (MessageEntity)_get;
        if (will != null) {
            observable.publish(will, new Object[0]);
        }
    }
}

