/**
 * Copyright (c) 2023 murenchao
 * taomu is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *       http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
package cool.taomu.util;

import java.net.InetSocketAddress;
import java.util.Collections;
import javax.security.sasl.Sasl;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.layered.TFramedTransport;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function0;
import org.eclipse.xtext.xbase.lib.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("all")
public class ThriftUtils {
  public interface TRpc {
    void callback(final TCompactProtocol protocol);
  }
  
  private static final Logger LOG = LoggerFactory.getLogger(ThriftUtils.class);
  
  public static void startKerberosServer(final TProcessor tprocessor, final InetSocketAddress isa) {
    TNonblockingServerSocket serverTransport = null;
    try {
      TNonblockingServerSocket _tNonblockingServerSocket = new TNonblockingServerSocket(isa);
      serverTransport = _tNonblockingServerSocket;
      TSaslServerTransport.Factory saslTransportFactory = new TSaslServerTransport.Factory();
      Pair<String, String> _mappedTo = Pair.<String, String>of(Sasl.QOP, "true");
      Pair<String, String> _mappedTo_1 = Pair.<String, String>of(Sasl.QOP, "auth-conf");
      saslTransportFactory.addServerDefinition(
        "GSSAPI", 
        "myserviceprincipal", 
        "my.server.com", 
        Collections.<String, String>unmodifiableMap(CollectionLiterals.<String, String>newHashMap(_mappedTo, _mappedTo_1)), 
        null);
      TThreadedSelectorServer.Args args = new TThreadedSelectorServer.Args(serverTransport);
      TCompactProtocol.Factory _factory = new TCompactProtocol.Factory();
      args.protocolFactory(_factory);
      args.transportFactory(saslTransportFactory);
      TProcessorFactory _tProcessorFactory = new TProcessorFactory(tprocessor);
      args.processorFactory(_tProcessorFactory);
      args.selectorThreads(4);
      int _availableProcessors = Runtime.getRuntime().availableProcessors();
      int _multiply = (_availableProcessors * 2);
      args.workerThreads(_multiply);
      args.acceptPolicy(TThreadedSelectorServer.Args.AcceptPolicy.FAST_ACCEPT);
      args.acceptQueueSizePerThread(8);
      TThreadedSelectorServer server = new TThreadedSelectorServer(args);
      System.out.println("start server....");
      server.serve();
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        if ((serverTransport != null)) {
          serverTransport.close();
        }
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  public static void startServer(final TProcessor tprocessor, final InetSocketAddress isa) {
    TNonblockingServerSocket serverTransport = null;
    try {
      TNonblockingServerSocket _tNonblockingServerSocket = new TNonblockingServerSocket(isa);
      serverTransport = _tNonblockingServerSocket;
      TThreadedSelectorServer.Args args = new TThreadedSelectorServer.Args(serverTransport);
      TCompactProtocol.Factory _factory = new TCompactProtocol.Factory();
      args.protocolFactory(_factory);
      TFramedTransport.Factory _factory_1 = new TFramedTransport.Factory();
      args.transportFactory(_factory_1);
      TProcessorFactory _tProcessorFactory = new TProcessorFactory(tprocessor);
      args.processorFactory(_tProcessorFactory);
      args.selectorThreads(4);
      int _availableProcessors = Runtime.getRuntime().availableProcessors();
      int _multiply = (_availableProcessors * 2);
      args.workerThreads(_multiply);
      args.acceptPolicy(TThreadedSelectorServer.Args.AcceptPolicy.FAST_ACCEPT);
      args.acceptQueueSizePerThread(8);
      TThreadedSelectorServer server = new TThreadedSelectorServer(args);
      System.out.println("start server....");
      server.serve();
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        if ((serverTransport != null)) {
          serverTransport.close();
        }
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  public static void startServer(final TProcessor tprocessor, final InetSocketAddress isa, final int max, final int min) {
    TNonblockingServerSocket socket = null;
    try {
      TNonblockingServerSocket _tNonblockingServerSocket = new TNonblockingServerSocket(isa);
      socket = _tNonblockingServerSocket;
      THsHaServer.Args arg = new THsHaServer.Args(socket).minWorkerThreads(min).maxWorkerThreads(max);
      TCompactProtocol.Factory _factory = new TCompactProtocol.Factory();
      arg.protocolFactory(_factory);
      TFramedTransport.Factory _factory_1 = new TFramedTransport.Factory();
      arg.transportFactory(_factory_1);
      TProcessorFactory _tProcessorFactory = new TProcessorFactory(tprocessor);
      arg.processorFactory(_tProcessorFactory);
      THsHaServer server = new THsHaServer(arg);
      System.out.println("start server....");
      server.serve();
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        if ((socket != null)) {
          socket.close();
        }
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  public static synchronized void rpc(final String host, final int port, final ThriftUtils.TRpc rpc) {
    ThriftUtils.LOG.info("host:{}", host);
    try {
      try (TFramedTransport tTransport = new Function0<TFramedTransport>() {
        @Override
        public TFramedTransport apply() {
          try {
            TSocket _tSocket = new TSocket(host, port);
            return new TFramedTransport(_tSocket);
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      }.apply()) {
        TCompactProtocol protocol = new TCompactProtocol(tTransport);
        if (((tTransport != null) && (!tTransport.isOpen()))) {
          tTransport.open();
        }
        if ((rpc != null)) {
          rpc.callback(protocol);
        }
      }
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception ex = (Exception)_t;
        ThriftUtils.LOG.info("client exception:", ex);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
}
