/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.util;

import java.net.InetSocketAddress;
import java.util.Collections;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;
import org.apache.thrift.transport.layered.TFramedTransport;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftUtils.class);

    public static void startKerberosServer(TProcessor tprocessor, InetSocketAddress isa) {
        TNonblockingServerSocket serverTransport = null;
        try {
            TNonblockingServerSocket _tNonblockingServerSocket;
            serverTransport = _tNonblockingServerSocket = new TNonblockingServerSocket(isa);
            TSaslServerTransport.Factory saslTransportFactory = new TSaslServerTransport.Factory();
            Pair _mappedTo = Pair.of((Object)"javax.security.sasl.qop", (Object)"true");
            Pair _mappedTo_1 = Pair.of((Object)"javax.security.sasl.qop", (Object)"auth-conf");
            saslTransportFactory.addServerDefinition("GSSAPI", "myserviceprincipal", "my.server.com", Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo, _mappedTo_1})), null);
            TThreadedSelectorServer.Args args = new TThreadedSelectorServer.Args((TNonblockingServerTransport)serverTransport);
            TCompactProtocol.Factory _factory = new TCompactProtocol.Factory();
            args.protocolFactory((TProtocolFactory)_factory);
            args.transportFactory((TTransportFactory)saslTransportFactory);
            TProcessorFactory _tProcessorFactory = new TProcessorFactory(tprocessor);
            args.processorFactory(_tProcessorFactory);
            args.selectorThreads(4);
            int _availableProcessors = Runtime.getRuntime().availableProcessors();
            int _multiply = _availableProcessors * 2;
            args.workerThreads(_multiply);
            args.acceptPolicy(TThreadedSelectorServer.Args.AcceptPolicy.FAST_ACCEPT);
            args.acceptQueueSizePerThread(8);
            TThreadedSelectorServer server = new TThreadedSelectorServer(args);
            System.out.println("start server....");
            server.serve();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                if (serverTransport != null) {
                    serverTransport.close();
                }
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static void startServer(TProcessor tprocessor, InetSocketAddress isa) {
        TNonblockingServerSocket serverTransport = null;
        try {
            TNonblockingServerSocket _tNonblockingServerSocket;
            serverTransport = _tNonblockingServerSocket = new TNonblockingServerSocket(isa);
            TThreadedSelectorServer.Args args = new TThreadedSelectorServer.Args((TNonblockingServerTransport)serverTransport);
            TCompactProtocol.Factory _factory = new TCompactProtocol.Factory();
            args.protocolFactory((TProtocolFactory)_factory);
            TFramedTransport.Factory _factory_1 = new TFramedTransport.Factory();
            args.transportFactory((TTransportFactory)_factory_1);
            TProcessorFactory _tProcessorFactory = new TProcessorFactory(tprocessor);
            args.processorFactory(_tProcessorFactory);
            args.selectorThreads(4);
            int _availableProcessors = Runtime.getRuntime().availableProcessors();
            int _multiply = _availableProcessors * 2;
            args.workerThreads(_multiply);
            args.acceptPolicy(TThreadedSelectorServer.Args.AcceptPolicy.FAST_ACCEPT);
            args.acceptQueueSizePerThread(8);
            TThreadedSelectorServer server = new TThreadedSelectorServer(args);
            System.out.println("start server....");
            server.serve();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                if (serverTransport != null) {
                    serverTransport.close();
                }
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static void startServer(TProcessor tprocessor, InetSocketAddress isa, int max, int min) {
        TNonblockingServerSocket socket = null;
        try {
            TNonblockingServerSocket _tNonblockingServerSocket;
            socket = _tNonblockingServerSocket = new TNonblockingServerSocket(isa);
            THsHaServer.Args arg = new THsHaServer.Args((TNonblockingServerTransport)socket).minWorkerThreads(min).maxWorkerThreads(max);
            TCompactProtocol.Factory _factory = new TCompactProtocol.Factory();
            arg.protocolFactory((TProtocolFactory)_factory);
            TFramedTransport.Factory _factory_1 = new TFramedTransport.Factory();
            arg.transportFactory((TTransportFactory)_factory_1);
            TProcessorFactory _tProcessorFactory = new TProcessorFactory(tprocessor);
            arg.processorFactory(_tProcessorFactory);
            THsHaServer server = new THsHaServer(arg);
            System.out.println("start server....");
            server.serve();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                if (socket != null) {
                    socket.close();
                }
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static synchronized void rpc(final String host, final int port, TRpc rpc) {
        LOG.info("host:{}", (Object)host);
        try (TFramedTransport tTransport = new Functions.Function0<TFramedTransport>(){

            public TFramedTransport apply() {
                try {
                    TSocket _tSocket = new TSocket(host, port);
                    return new TFramedTransport((TTransport)_tSocket);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        }.apply();){
            TCompactProtocol protocol = new TCompactProtocol((TTransport)tTransport);
            if (tTransport != null && !tTransport.isOpen()) {
                tTransport.open();
            }
            if (rpc != null) {
                rpc.callback(protocol);
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception ex = (Exception)_t;
                LOG.info("client exception:", (Throwable)ex);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static interface TRpc {
        public void callback(TCompactProtocol var1);
    }
}

