/*
 * Decompiled with CFR 0.152.
 */
package cool.taomu.thrift.guice;

import cool.taomu.core.TaomuTask;
import cool.taomu.core.entity.TaskEntity;
import cool.taomu.core.inter.ITaomuService;
import cool.taomu.thrift.NetworkThread;
import cool.taomu.thrift.entity.ThriftConfig;
import cool.taomu.util.ThriftUtils;
import cool.taomu.util.YamlUtils;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.inject.Inject;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.thrift.TException;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkThreadServer
implements NetworkThread.Iface,
ITaomuService {
    private final Logger LOG = LoggerFactory.getLogger(NetworkThreadServer.class);
    @Inject
    private TaomuTask taomuTask;

    @Override
    public void execute(ByteBuffer data) throws TException {
        try {
            byte[] ser = Arrays.copyOfRange(data.array(), data.position(), data.limit());
            Object _deserialize = SerializationUtils.deserialize((byte[])ser);
            TaskEntity task = (TaskEntity)_deserialize;
            if (this.taomuTask == null) {
                throw new NullPointerException();
            }
            this.taomuTask.add(task);
        }
        catch (Throwable _t) {
            if (_t instanceof SerializationException) {
                SerializationException ex = (SerializationException)_t;
                this.LOG.info("\u53cd\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)ex);
            }
            if (_t instanceof Exception) {
                Exception ex_1 = (Exception)_t;
                this.LOG.info("Exception:", (Throwable)ex_1);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static void start(String host, int port, int max, int min) {
        NetworkThreadServer _networkThreadServer = new NetworkThreadServer();
        NetworkThread.Processor<NetworkThreadServer> tprocessor = new NetworkThread.Processor<NetworkThreadServer>(_networkThreadServer);
        InetSocketAddress isa = new InetSocketAddress(host, port);
        ThriftUtils.startServer(tprocessor, isa, max, min);
    }

    public static void start(String host, int port) {
        NetworkThreadServer _networkThreadServer = new NetworkThreadServer();
        NetworkThread.Processor<NetworkThreadServer> tprocessor = new NetworkThread.Processor<NetworkThreadServer>(_networkThreadServer);
        InetSocketAddress isa = new InetSocketAddress(host, port);
        ThriftUtils.startServer(tprocessor, isa);
    }

    public void service(TaomuTask factory) {
        this.taomuTask = factory;
        ThriftConfig config = (ThriftConfig)YamlUtils.read((String)"./config/thrift.yml", ThriftConfig.class);
        NetworkThreadServer.start(config.getHost(), config.getPort(), config.getMaxThreads(), config.getMinThreads());
    }
}

