/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.examples;

import cz.abclinuxu.datoveschranky.common.entities.MessageEnvelope;
import cz.abclinuxu.datoveschranky.common.impl.Config;
import cz.abclinuxu.datoveschranky.common.impl.DataBoxEnvironment;
import cz.abclinuxu.datoveschranky.impl.Authentication;
import cz.abclinuxu.datoveschranky.impl.BasicAuthentication;
import cz.abclinuxu.datoveschranky.impl.DataBoxManager;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class Downloader {
    private DataBoxManager manager;
    private int threads;

    public Downloader(DataBoxManager manager, int threads) {
        this.manager = manager;
        this.threads = threads;
    }

    public void download() throws Exception {
        GregorianCalendar begin = new GregorianCalendar();
        begin.roll(6, -10);
        GregorianCalendar end = new GregorianCalendar();
        end.roll(6, 1);
        List<MessageEnvelope> result = Collections.synchronizedList(new LinkedList(this.manager.getDataBoxMessagesService().getListOfReceivedMessages(begin.getTime(), end.getTime(), null, 0, 500)));
        LinkedList<DownloadThread> threadsToWait = new LinkedList<DownloadThread>();
        for (int i = 0; i != this.threads; ++i) {
            DownloadThread thread = new DownloadThread(this.manager, result);
            threadsToWait.add(thread);
            thread.start();
        }
        for (DownloadThread thread : threadsToWait) {
            thread.join();
        }
    }

    public static void main(String[] args) throws Exception {
        int threads = Integer.parseInt(args[1]);
        String propertiesFile = args[0];
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream(propertiesFile);
        props.load(fis);
        fis.close();
        String login = props.getProperty("downloader.login");
        String passwd = props.getProperty("downloader.password");
        Config config = new Config(DataBoxEnvironment.TEST);
        BasicAuthentication auth = new BasicAuthentication(config, login, passwd);
        DataBoxManager manager = new DataBoxManager(config, (Authentication)auth);
        Downloader downloader = new Downloader(manager, threads);
        downloader.download();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DownloadThread
    extends Thread {
        private DataBoxManager manager;
        private List<MessageEnvelope> envelopes;

        public DownloadThread(DataBoxManager manager, List<MessageEnvelope> envelopes) {
            this.manager = manager;
            this.envelopes = envelopes;
        }

        @Override
        public void run() {
            while (!this.envelopes.isEmpty()) {
                MessageEnvelope envelope = this.envelopes.remove(0);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.manager.getDataBoxDownloadService().downloadSignedMessage(envelope, (OutputStream)os);
            }
        }
    }
}

