/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.common.entities;

import cz.abclinuxu.datoveschranky.common.entities.DataBoxType;
import cz.abclinuxu.datoveschranky.common.entities.Validator;
import java.io.Serializable;

public class DataBox
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String dataBoxID = null;
    private String identity = null;
    private String address = null;
    private DataBoxType dataBoxType = null;

    public DataBox() {
    }

    public DataBox(String id) {
        this.dataBoxID = id;
    }

    public DataBox(String id, String name, String adress) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.dataBoxID = id;
        this.identity = name;
        this.address = adress;
    }

    public DataBox(String id, DataBoxType dataBoxType, String name, String adress) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.dataBoxID = id;
        this.identity = name;
        this.address = adress;
        this.dataBoxType = dataBoxType;
    }

    public String getDataBoxID() {
        return this.dataBoxID;
    }

    public void setDataBoxID(String newID) {
        Validator.assertNotNull(newID);
        Validator.assertValidDataBoxID(newID);
        this.dataBoxID = newID;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String toString() {
        return String.format("DataBox{id='%s'}", this.dataBoxID);
    }

    public DataBoxType getDataBoxType() {
        return this.dataBoxType;
    }

    public void setDataBoxType(DataBoxType type) {
        this.dataBoxType = type;
    }
}

