/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.common.entities;

import cz.abclinuxu.datoveschranky.common.MimeTypes;
import cz.abclinuxu.datoveschranky.common.entities.Validator;
import cz.abclinuxu.datoveschranky.common.entities.content.Content;
import java.io.Serializable;

public class Attachment
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String description = null;
    private String metaType = null;
    private String mimeType = null;
    private Content content = null;

    public Attachment() {
    }

    public Attachment(String descr, Content cont) {
        if (descr == null) {
            throw new NullPointerException(descr);
        }
        this.description = descr;
        this.content = cont;
        this.setAutoMimeType(descr);
    }

    public Content getContent() {
        return this.content;
    }

    public void setContents(Content cont) {
        this.content = cont;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescr) {
        Validator.assertNotNull(newDescr);
        this.description = newDescr;
        this.setAutoMimeType(newDescr);
    }

    public String getMetaType() {
        return this.metaType;
    }

    public void setMetaType(String metaType) {
        this.metaType = metaType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    private void setAutoMimeType(String desc) {
        String newMimeType = MimeTypes.fileNameToMimeType(desc);
        if (newMimeType != null) {
            this.setMimeType(newMimeType);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Attachment{");
        sb.append("description='").append(this.description).append('\'');
        sb.append(", metaType='").append(this.metaType).append('\'');
        sb.append(", mimeType='").append(this.mimeType).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

