/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.common.entities;

import cz.abclinuxu.datoveschranky.common.entities.DataBox;
import cz.abclinuxu.datoveschranky.common.entities.DocumentIdent;
import cz.abclinuxu.datoveschranky.common.entities.LegalTitle;
import cz.abclinuxu.datoveschranky.common.entities.MessageState;
import cz.abclinuxu.datoveschranky.common.entities.MessageType;
import cz.abclinuxu.datoveschranky.common.entities.Validator;
import java.io.Serializable;
import java.util.GregorianCalendar;

public class MessageEnvelope
implements Serializable {
    private static final long serialVersionUID = 4L;
    private DataBox sender = null;
    private DocumentIdent senderIdent;
    private DataBox recipient = null;
    private DocumentIdent recipientIdent;
    private MessageType type = null;
    private MessageState state = null;
    private String id = null;
    private String annotation = null;
    private GregorianCalendar deliveryTime = null;
    private GregorianCalendar acceptanceTime = null;
    private String toHands;
    private LegalTitle legalTitle;
    private boolean personalDelivery;
    private boolean allowSubstDelivery;
    private String dmType = null;

    public MessageEnvelope() {
        this.type = MessageType.CREATED;
    }

    public MessageEnvelope(MessageType type, DataBox sender, DataBox recipient, String id, String annotation) {
        Validator.assertNotNull((Object)type);
        Validator.assertNotNull(sender);
        Validator.assertNotNull(recipient);
        Validator.assertNotNull(id);
        Validator.assertValidMessageID(id);
        this.type = type;
        this.sender = sender;
        this.recipient = recipient;
        this.id = id;
        this.annotation = annotation;
    }

    public MessageEnvelope(MessageType type, DataBox sender, DataBox recipient, String id, String annotation, LegalTitle legalTitle, String toHands, boolean personalDelivery, boolean allowSubstDelivery) {
        this(type, sender, recipient, id, annotation);
        this.legalTitle = legalTitle;
        this.toHands = toHands;
        this.allowSubstDelivery = allowSubstDelivery;
        this.personalDelivery = personalDelivery;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public DataBox getRecipient() {
        return this.recipient;
    }

    public void setRecipient(DataBox recipient) {
        Validator.assertNotNull(recipient);
        this.recipient = recipient;
    }

    public DataBox getSender() {
        return this.sender;
    }

    public void setSender(DataBox sender) {
        Validator.assertNotNull(sender);
        this.sender = sender;
    }

    public String getMessageID() {
        return this.id;
    }

    public void setMessageID(String newID) {
        Validator.assertNotNull(newID);
        this.id = newID;
    }

    public MessageType getType() {
        return this.type;
    }

    public void setType(MessageType type) {
        Validator.assertNotNull((Object)type);
        this.type = type;
    }

    public MessageState getState() {
        return this.state;
    }

    public void setState(MessageState state) {
        this.state = state;
    }

    public DocumentIdent getRecipientIdent() {
        return this.recipientIdent;
    }

    public void setRecipientIdent(DocumentIdent recipientIdent) {
        this.recipientIdent = recipientIdent;
    }

    public DocumentIdent getSenderIdent() {
        return this.senderIdent;
    }

    public void setSenderIdent(DocumentIdent senderIdent) {
        this.senderIdent = senderIdent;
    }

    public GregorianCalendar getAcceptanceTime() {
        return this.acceptanceTime;
    }

    public void setAcceptanceTime(GregorianCalendar acceptanceTime) {
        this.acceptanceTime = acceptanceTime;
    }

    public GregorianCalendar getDeliveryTime() {
        return this.deliveryTime;
    }

    public void setDeliveryTime(GregorianCalendar deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MessageEnvelope{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", sender=").append(this.sender);
        sb.append(", recipient=").append(this.recipient);
        sb.append(", type=").append((Object)this.type);
        sb.append(", state=").append((Object)this.state);
        sb.append(", annotation='").append(this.annotation).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public String getDmType() {
        return this.dmType;
    }

    public void setDmType(String dmType) {
        this.dmType = dmType;
    }

    public boolean isAllowSubstDelivery() {
        return this.allowSubstDelivery;
    }

    public void setAllowSubstDelivery(boolean allowSubstDelivery) {
        this.allowSubstDelivery = allowSubstDelivery;
    }

    public LegalTitle getLegalTitle() {
        return this.legalTitle;
    }

    public void setLegalTitle(LegalTitle legalTitle) {
        this.legalTitle = legalTitle;
    }

    public boolean getPersonalDelivery() {
        return this.personalDelivery;
    }

    public void setPersonalDelivery(boolean personalDelivery) {
        this.personalDelivery = personalDelivery;
    }

    public String getToHands() {
        return this.toHands;
    }

    public void setToHands(String toHands) {
        this.toHands = toHands;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageEnvelope)) {
            return false;
        }
        MessageEnvelope that = (MessageEnvelope)o;
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

