/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.impl;

import cz.abclinuxu.datoveschranky.common.impl.Config;
import cz.abclinuxu.datoveschranky.common.impl.Utils;
import java.security.KeyStore;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Authentication {
    protected final Config config;
    protected final Logger logger = Logger.getLogger(this.getClass().getName());

    protected Authentication(Config config) {
        this.config = config;
    }

    public <T> T createService(Service serviceBuilder, Class<T> serviceClass, String servicePostfix) {
        Object service = serviceBuilder.getPort(serviceClass);
        this.configureService(((BindingProvider)service).getRequestContext(), servicePostfix);
        return (T)service;
    }

    protected void configureService(Map<String, Object> requestContext, String servicePostfix) {
        requestContext.put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", this.createSSLSocketFactory());
        requestContext.put("javax.xml.ws.service.endpoint.address", this.config.getServiceURL() + servicePostfix);
        this.configureServiceOverride(requestContext, servicePostfix);
    }

    protected SSLSocketFactory createSSLSocketFactory() {
        KeyStore keyStore = this.config.getKeyStore();
        return Utils.createSSLSocketFactory((KeyStore)keyStore);
    }

    protected abstract void configureServiceOverride(Map<String, Object> var1, String var2);
}

