/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.impl;

import cz.abclinuxu.datoveschranky.common.impl.Config;
import cz.abclinuxu.datoveschranky.common.impl.DataBoxException;
import cz.abclinuxu.datoveschranky.impl.Authentication;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientCertAuthentication
extends Authentication {
    protected File certFile;
    protected String certPassword;

    public ClientCertAuthentication(Config config, File certFile, String certPassword) {
        super(config);
        KeyStore keyStore = config.getKeyStore();
        this.certFile = certFile;
        this.certPassword = certPassword;
    }

    @Override
    protected void configureServiceOverride(Map<String, Object> requestContext, String servicePostfix) {
    }

    @Override
    protected void configureService(Map<String, Object> requestContext, String servicePostfix) {
        requestContext.put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", this.createSSLSocketFactory());
        requestContext.put("javax.xml.ws.service.endpoint.address", this.config.getServiceURLClientCert() + servicePostfix);
        this.configureServiceOverride(requestContext, servicePostfix);
    }

    @Override
    protected SSLSocketFactory createSSLSocketFactory() throws DataBoxException {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            FileInputStream keyInput = new FileInputStream(this.certFile);
            keyStore.load(keyInput, this.certPassword.toCharArray());
            ((InputStream)keyInput).close();
            keyManagerFactory.init(keyStore, this.certPassword.toCharArray());
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
            return context.getSocketFactory();
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new DataBoxException("Can't create SSLSocketFactory.", ex);
        }
    }
}

