/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.impl;

import cz.abclinuxu.datoveschranky.common.entities.Address;
import cz.abclinuxu.datoveschranky.common.entities.DataBox;
import cz.abclinuxu.datoveschranky.common.entities.DataBoxState;
import cz.abclinuxu.datoveschranky.common.entities.DataBoxType;
import cz.abclinuxu.datoveschranky.common.entities.DataBoxWithDetails;
import cz.abclinuxu.datoveschranky.common.entities.SearchResult;
import cz.abclinuxu.datoveschranky.common.interfaces.DataBoxSearchService;
import cz.abclinuxu.datoveschranky.impl.ErrorHandling;
import cz.abclinuxu.datoveschranky.ws.db.DataBoxManipulationPortType;
import cz.abclinuxu.datoveschranky.ws.db.TDbOwnerInfo;
import cz.abclinuxu.datoveschranky.ws.db.TDbOwnersArray;
import cz.abclinuxu.datoveschranky.ws.db.TDbReqStatus;
import cz.abclinuxu.datoveschranky.ws.db.TDbType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBoxSearchServiceImpl
implements DataBoxSearchService {
    protected static final int MIN_PREFIX_LENGHT = 3;
    protected static final String OK = "0000";
    protected static final String SEARCH_LIMIT_REACHED = "0003";
    protected static final String NOTHING_FOUND = "0002";
    protected static final String NO_UNIQUE_RESULT = "1109";
    protected static final List<String> searchOKCodes = Arrays.asList("0000", "0003", "0002", "1109");
    protected static final Map<String, SearchResult.Status> codeToStatus = new HashMap<String, SearchResult.Status>();
    protected static final Map<DataBoxType, TDbType> types;
    protected static final Map<TDbType, DataBoxType> typesInverted;
    protected DataBoxManipulationPortType service;

    public DataBoxSearchServiceImpl(DataBoxManipulationPortType serv) {
        this.service = serv;
    }

    public DataBoxState checkDataBox(DataBox db) {
        String id = db.getDataBoxID();
        Holder dbState = new Holder();
        Holder status = new Holder();
        this.service.checkDataBox(id, Boolean.valueOf(true), "", dbState, status);
        ErrorHandling.throwIfError(String.format("Chyba pri zjistovani stavu schranky s id=%s.", db.getDataBoxID()), (TDbReqStatus)status.value);
        return DataBoxState.create((int)((Integer)dbState.value));
    }

    public List<DataBoxWithDetails> findOVMsByName(String prefix) {
        if (prefix.length() < 3) {
            throw new IllegalArgumentException(String.format("Prefix musi obsahovat alespon %d znaky.", 3));
        }
        TDbOwnerInfo ownerInfo = new TDbOwnerInfo();
        ownerInfo.setFirmName(prefix);
        ownerInfo.setDbType(TDbType.OVM);
        Holder owners = new Holder();
        Holder status = new Holder();
        this.service.findDataBox(ownerInfo, owners, status);
        if (!searchOKCodes.contains(((TDbReqStatus)status.value).getDbStatusCode())) {
            ErrorHandling.throwIfError("Nemohu najit OVM.", (TDbReqStatus)status.value);
        }
        ArrayList<DataBoxWithDetails> result = new ArrayList<DataBoxWithDetails>();
        for (TDbOwnerInfo owner : ((TDbOwnersArray)owners.value).getDbOwnerInfo()) {
            result.add(DataBoxSearchServiceImpl.create(owner));
        }
        return result;
    }

    public SearchResult find(DataBoxWithDetails what) {
        TDbOwnerInfo ownerInfo = new TDbOwnerInfo();
        if (what.getDataBoxType() != null) {
            ownerInfo.setDbType(types.get(what.getDataBoxType()));
        } else {
            ownerInfo.setDbType(null);
        }
        if (what.getIC() != null) {
            ownerInfo.setIc(what.getIC());
        }
        if (what.getIdentity() != null) {
            ownerInfo.setFirmName(what.getIdentity());
        }
        if (what.getAddressDetails() != null) {
            Address address = what.getAddressDetails();
            if (address.getCity() != null) {
                ownerInfo.setAdCity(address.getCity());
            }
            if (address.getStreet() != null) {
                ownerInfo.setAdStreet(address.getStreet());
            }
            if (address.getNumberInMunicipality() != null) {
                ownerInfo.setAdNumberInMunicipality(address.getNumberInMunicipality());
            }
            if (address.getNumberInStreet() != null) {
                ownerInfo.setAdNumberInStreet(address.getNumberInStreet());
            }
        }
        Holder owners = new Holder();
        Holder status = new Holder();
        this.service.findDataBox(ownerInfo, owners, status);
        SearchResult.Status statusOfSearch = codeToStatus.get(((TDbReqStatus)status.value).getDbStatusCode());
        if (statusOfSearch == null) {
            ErrorHandling.throwIfError(String.format("Search failed with status: %s (%s)", ((TDbReqStatus)status.value).getDbStatusCode(), ((TDbReqStatus)status.value).getDbStatusMessage()), (TDbReqStatus)status.value);
        }
        ArrayList<DataBoxWithDetails> results = new ArrayList<DataBoxWithDetails>();
        for (TDbOwnerInfo owner : ((TDbOwnersArray)owners.value).getDbOwnerInfo()) {
            results.add(DataBoxSearchServiceImpl.create(owner));
        }
        SearchResult result = new SearchResult();
        result.setResult(results);
        result.setStatus(statusOfSearch);
        return result;
    }

    public List<DataBoxWithDetails> find(DataBoxType type, DataBoxWithDetails what) {
        TDbOwnerInfo ownerInfo = new TDbOwnerInfo();
        if (type != null) {
            ownerInfo.setDbType(types.get(type));
        } else {
            ownerInfo.setDbType(null);
        }
        if (what.getIC() != null) {
            ownerInfo.setIc(what.getIC());
        }
        if (what.getIdentity() != null) {
            ownerInfo.setFirmName(what.getIdentity());
        }
        if (what.getAddressDetails() != null) {
            Address address = what.getAddressDetails();
            if (address.getCity() != null) {
                ownerInfo.setAdCity(address.getCity());
            }
            if (address.getStreet() != null) {
                ownerInfo.setAdStreet(address.getStreet());
            }
            if (address.getNumberInMunicipality() != null) {
                ownerInfo.setAdNumberInMunicipality(address.getNumberInMunicipality());
            }
            if (address.getNumberInStreet() != null) {
                ownerInfo.setAdNumberInStreet(address.getNumberInStreet());
            }
        }
        Holder owners = new Holder();
        Holder status = new Holder();
        this.service.findDataBox(ownerInfo, owners, status);
        if (!searchOKCodes.contains(((TDbReqStatus)status.value).getDbStatusCode())) {
            ErrorHandling.throwIfError("Nemohu najit OVM.", (TDbReqStatus)status.value);
        }
        ArrayList<DataBoxWithDetails> result = new ArrayList<DataBoxWithDetails>();
        for (TDbOwnerInfo owner : ((TDbOwnersArray)owners.value).getDbOwnerInfo()) {
            result.add(DataBoxSearchServiceImpl.create(owner));
        }
        return result;
    }

    public DataBoxWithDetails findDataBoxByID(String id) {
        if (id == null) {
            throw new NullPointerException(id);
        }
        Holder owners = new Holder();
        Holder status = new Holder();
        TDbOwnerInfo ownerInfo = new TDbOwnerInfo();
        ownerInfo.setDbID(id);
        this.service.findDataBox(ownerInfo, owners, status);
        ErrorHandling.throwIfError(String.format("Chyba p\u0159i hledan\u00ed datov\u00e9 schr\u00e1nky s id=%s.", id), (TDbReqStatus)status.value);
        List found = ((TDbOwnersArray)owners.value).getDbOwnerInfo();
        if (found.size() > 1) {
            throw new AssertionError((Object)String.format("Metoda findDataBoxByID pri hledani datove schranky s id=%s vratila vice nez jednu schranku.", id));
        }
        if (found.size() == 1) {
            return DataBoxSearchServiceImpl.create((TDbOwnerInfo)found.get(0));
        }
        return null;
    }

    static DataBoxWithDetails create(TDbOwnerInfo owner) {
        DataBoxWithDetails result = new DataBoxWithDetails(owner.getDbID());
        result.setDataBoxType(typesInverted.get(owner.getDbType()));
        result.setIdentity(owner.getFirmName());
        String street = null;
        street = owner.getAdNumberInMunicipality() == null || owner.getAdNumberInMunicipality().trim().equals("") ? String.format("%s %s", owner.getAdStreet(), owner.getAdNumberInStreet()) : String.format("%s %s/%s", owner.getAdStreet(), owner.getAdNumberInMunicipality(), owner.getAdNumberInStreet());
        String address = String.format("%s, %s %s, %s", street, owner.getAdZipCode(), owner.getAdCity(), owner.getAdState());
        result.setAddress(address);
        result.setIC(owner.getIc());
        Address addressDetail = new Address();
        addressDetail.setCity(owner.getAdCity());
        addressDetail.setNumberInMunicipality(owner.getAdNumberInMunicipality());
        addressDetail.setNumberInStreet(owner.getAdNumberInStreet());
        addressDetail.setState(owner.getAdState());
        addressDetail.setStreet(owner.getAdStreet());
        addressDetail.setZipCode(owner.getAdZipCode());
        result.setAddressDetails(addressDetail);
        return result;
    }

    static {
        codeToStatus.put(OK, SearchResult.Status.COMPLETE);
        codeToStatus.put(SEARCH_LIMIT_REACHED, SearchResult.Status.SEARCH_LIMIT_REACHED);
        codeToStatus.put(NOTHING_FOUND, SearchResult.Status.EMPTY);
        codeToStatus.put(NO_UNIQUE_RESULT, SearchResult.Status.NO_UNIQUE_RESULT);
        types = new HashMap<DataBoxType, TDbType>();
        typesInverted = new HashMap<TDbType, DataBoxType>();
        types.put(DataBoxType.FO, TDbType.FO);
        types.put(DataBoxType.OVM, TDbType.OVM);
        types.put(DataBoxType.OVM_EXEKUT, TDbType.OVM_EXEKUT);
        types.put(DataBoxType.OVM_NOTAR, TDbType.OVM_NOTAR);
        types.put(DataBoxType.OVM_REQ, TDbType.OVM_REQ);
        types.put(DataBoxType.PFO, TDbType.PFO);
        types.put(DataBoxType.PFO_ADVOK, TDbType.PFO_ADVOK);
        types.put(DataBoxType.PFO_DANPOR, TDbType.PFO_DANPOR);
        types.put(DataBoxType.PFO_INSSPR, TDbType.PFO_INSSPR);
        types.put(DataBoxType.PO, TDbType.PO);
        types.put(DataBoxType.PO_REQ, TDbType.PO_REQ);
        types.put(DataBoxType.PO_ZAK, TDbType.PO_ZAK);
        for (Map.Entry<DataBoxType, TDbType> entry : types.entrySet()) {
            typesInverted.put(entry.getValue(), entry.getKey());
        }
    }
}

