/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.impl;

import cz.abclinuxu.datoveschranky.common.entities.Attachment;
import cz.abclinuxu.datoveschranky.common.entities.LegalTitle;
import cz.abclinuxu.datoveschranky.common.entities.Message;
import cz.abclinuxu.datoveschranky.common.entities.MessageType;
import cz.abclinuxu.datoveschranky.common.entities.Validator;
import cz.abclinuxu.datoveschranky.common.impl.DataBoxException;
import cz.abclinuxu.datoveschranky.common.impl.Utils;
import cz.abclinuxu.datoveschranky.common.interfaces.DataBoxUploadService;
import cz.abclinuxu.datoveschranky.impl.ErrorHandling;
import cz.abclinuxu.datoveschranky.ws.dm.DmOperationsPortType;
import cz.abclinuxu.datoveschranky.ws.dm.TFilesArray;
import cz.abclinuxu.datoveschranky.ws.dm.TMessageCreateInput;
import cz.abclinuxu.datoveschranky.ws.dm.TStatus;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import javax.xml.ws.Holder;

public class DataBoxUploadServiceImpl
implements DataBoxUploadService {
    protected DmOperationsPortType dmOp;

    public DataBoxUploadServiceImpl(DmOperationsPortType dmOp) {
        this.dmOp = dmOp;
    }

    public void sendMessage(Message message) {
        Validator.assertValidMessageForSending((Message)message);
        TMessageCreateInput.DmEnvelope envelope = new TMessageCreateInput.DmEnvelope();
        envelope.setDbIDRecipient(message.getEnvelope().getRecipient().getDataBoxID());
        envelope.setDmAnnotation(message.getEnvelope().getAnnotation());
        LegalTitle legalTitle = message.getEnvelope().getLegalTitle();
        if (legalTitle != null) {
            if (legalTitle.getLaw() != null) {
                envelope.setDmLegalTitleLaw(BigInteger.valueOf(Long.parseLong(legalTitle.getLaw())));
            }
            envelope.setDmLegalTitlePar(legalTitle.getPar());
            envelope.setDmLegalTitlePoint(legalTitle.getPoint());
            envelope.setDmLegalTitleSect(legalTitle.getSect());
            if (legalTitle.getYear() != null) {
                envelope.setDmLegalTitleYear(BigInteger.valueOf(Long.parseLong(legalTitle.getYear())));
            }
        }
        envelope.setDmToHands(message.getEnvelope().getToHands());
        envelope.setDmPersonalDelivery(Boolean.valueOf(message.getEnvelope().getPersonalDelivery()));
        if (message.getEnvelope().getRecipientIdent() != null) {
            envelope.setDmRecipientIdent(message.getEnvelope().getRecipientIdent().getIdent());
            envelope.setDmRecipientRefNumber(message.getEnvelope().getRecipientIdent().getRefNumber());
        }
        if (message.getEnvelope().getSenderIdent() != null) {
            envelope.setDmSenderIdent(message.getEnvelope().getSenderIdent().getIdent());
            envelope.setDmSenderRefNumber(message.getEnvelope().getSenderIdent().getRefNumber());
        }
        TFilesArray files = new TFilesArray();
        for (Attachment attachment : message.getAttachments()) {
            TFilesArray.DmFile file = new TFilesArray.DmFile();
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Utils.copy((InputStream)attachment.getContent().getInputStream(), (OutputStream)out);
                file.setDmEncodedContent(out.toByteArray());
            }
            catch (IOException ioe) {
                throw new DataBoxException("IO chyba pri cteni prilohy.", (Exception)ioe);
            }
            file.setDmMimeType(attachment.getMimeType());
            file.setDmFileMetaType(attachment.getMetaType());
            file.setDmFileDescr(attachment.getDescription());
            files.getDmFile().add(file);
        }
        Holder messageID = new Holder();
        Holder status = new Holder();
        if (message.getEnvelope().getDmType() != null) {
            envelope.setDmType(message.getEnvelope().getDmType());
        }
        this.dmOp.createMessage(envelope, files, messageID, status);
        ErrorHandling.throwIfError("Poslani zpravy se nezdarilo", (TStatus)status.value);
        message.getEnvelope().setType(MessageType.SENT);
        message.getEnvelope().setMessageID((String)messageID.value);
    }
}

