/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.impl;

import cz.abclinuxu.datoveschranky.common.Config;
import cz.abclinuxu.datoveschranky.common.interfaces.DataBoxAccessService;
import cz.abclinuxu.datoveschranky.common.interfaces.DataBoxDownloadService;
import cz.abclinuxu.datoveschranky.common.interfaces.DataBoxMessagesService;
import cz.abclinuxu.datoveschranky.common.interfaces.DataBoxSearchService;
import cz.abclinuxu.datoveschranky.common.interfaces.DataBoxServices;
import cz.abclinuxu.datoveschranky.common.interfaces.DataBoxUploadService;
import cz.abclinuxu.datoveschranky.impl.Authentication;
import cz.abclinuxu.datoveschranky.impl.BasicAuthentication;
import cz.abclinuxu.datoveschranky.impl.DataBoxDownloadServiceImpl;
import cz.abclinuxu.datoveschranky.impl.DataBoxMessagesServiceImpl;
import cz.abclinuxu.datoveschranky.impl.DataBoxSearchServiceImpl;
import cz.abclinuxu.datoveschranky.impl.DataBoxUploadServiceImpl;
import cz.abclinuxu.datoveschranky.impl.MessageValidator;
import cz.abclinuxu.datoveschranky.ws.ServiceBuilder;
import cz.abclinuxu.datoveschranky.ws.db.DataBoxManipulationPortType;
import cz.abclinuxu.datoveschranky.ws.dm.DmInfoPortType;
import cz.abclinuxu.datoveschranky.ws.dm.DmOperationsPortType;
import java.io.File;

public class DataBoxManager
implements DataBoxServices {
    protected Authentication auth = null;
    protected Config config = null;
    protected DataBoxMessagesService dataBoxMessagesService = null;
    protected DataBoxDownloadService dataBoxDownloadService = null;
    protected DataBoxUploadService dataBoxUploadService = null;
    protected DataBoxSearchServiceImpl dataBoxFindingService = null;
    protected MessageValidator messageValidator = null;

    public DataBoxManager(Config conf, Authentication auth) {
        this.auth = auth;
        this.config = conf;
        this.messageValidator = new MessageValidator(this.config);
    }

    public static DataBoxManager login(Config config, String userName, String password) throws Exception {
        Authentication auth = BasicAuthentication.login(config, userName, password);
        DataBoxManager manager = new DataBoxManager(config, auth);
        return manager;
    }

    public static DataBoxManager login(Config config, File clientCert, String password) throws Exception {
        return null;
    }

    public DataBoxDownloadService getDataBoxDownloadService() {
        if (this.dataBoxDownloadService == null) {
            DmOperationsPortType dataMessageOperationsService = this.auth.createService(ServiceBuilder.createDmOperationsWebService(), DmOperationsPortType.class, "dz");
            this.dataBoxDownloadService = new DataBoxDownloadServiceImpl(dataMessageOperationsService, this.messageValidator);
        }
        return this.dataBoxDownloadService;
    }

    public DataBoxMessagesService getDataBoxMessagesService() {
        if (this.dataBoxMessagesService == null) {
            DmInfoPortType dataMessageInfo = this.auth.createService(ServiceBuilder.createDmInfoWebService(), DmInfoPortType.class, "dx");
            this.dataBoxMessagesService = new DataBoxMessagesServiceImpl(dataMessageInfo);
        }
        return this.dataBoxMessagesService;
    }

    public DataBoxUploadService getDataBoxUploadService() {
        if (this.dataBoxUploadService == null) {
            DmOperationsPortType dataMessageOperationsService = this.auth.createService(ServiceBuilder.createDmOperationsWebService(), DmOperationsPortType.class, "dz");
            this.dataBoxUploadService = new DataBoxUploadServiceImpl(dataMessageOperationsService);
        }
        return this.dataBoxUploadService;
    }

    public DataBoxSearchService getDataBoxSearchService() {
        if (this.dataBoxFindingService == null) {
            DataBoxManipulationPortType service = this.auth.createService(ServiceBuilder.createDataBoxManipulation(), DataBoxManipulationPortType.class, "df");
            this.dataBoxFindingService = new DataBoxSearchServiceImpl(service);
        }
        return this.dataBoxFindingService;
    }

    public DataBoxAccessService getDataBoxAccessService() {
        throw new UnsupportedOperationException("Operace getDataBoxAccessService neni touto knihovnou podporovana.");
    }
}

