/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.impl;

import cz.abclinuxu.datoveschranky.common.DataBoxException;
import cz.abclinuxu.datoveschranky.common.entities.DataBox;
import cz.abclinuxu.datoveschranky.common.entities.DeliveryInfo;
import cz.abclinuxu.datoveschranky.common.entities.DocumentIdent;
import cz.abclinuxu.datoveschranky.common.entities.Hash;
import cz.abclinuxu.datoveschranky.common.entities.MessageEnvelope;
import cz.abclinuxu.datoveschranky.common.entities.MessageState;
import cz.abclinuxu.datoveschranky.common.entities.MessageStateChange;
import cz.abclinuxu.datoveschranky.common.entities.MessageType;
import cz.abclinuxu.datoveschranky.common.interfaces.DataBoxMessagesService;
import cz.abclinuxu.datoveschranky.impl.ErrorHandling;
import cz.abclinuxu.datoveschranky.impl.MessageValidator;
import cz.abclinuxu.datoveschranky.ws.XMLUtils;
import cz.abclinuxu.datoveschranky.ws.dm.DmInfoPortType;
import cz.abclinuxu.datoveschranky.ws.dm.TDelivery;
import cz.abclinuxu.datoveschranky.ws.dm.THash;
import cz.abclinuxu.datoveschranky.ws.dm.TRecord;
import cz.abclinuxu.datoveschranky.ws.dm.TRecordsArray;
import cz.abclinuxu.datoveschranky.ws.dm.TStateChangesArray;
import cz.abclinuxu.datoveschranky.ws.dm.TStateChangesRecord;
import cz.abclinuxu.datoveschranky.ws.dm.TStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.Holder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBoxMessagesServiceImpl
implements DataBoxMessagesService {
    protected DmInfoPortType dataMessageInfo;
    static Logger logger = Logger.getLogger(DataBoxMessagesServiceImpl.class);

    public DataBoxMessagesServiceImpl(DmInfoPortType dmInfo) {
        this.dataMessageInfo = dmInfo;
    }

    @Override
    public List<MessageEnvelope> getListOfReceivedMessages(Date from, Date to, EnumSet<MessageState> filter, int offset, int limit) {
        logger.info((Object)String.format("getListOfReceivedMessages: offset:%s limit:%s", offset, limit));
        Holder records = new Holder();
        Holder status = new Holder();
        XMLGregorianCalendar xmlFrom = XMLUtils.toXmlDate(from);
        XMLGregorianCalendar xmlTo = XMLUtils.toXmlDate(to);
        BigInteger bOffset = BigInteger.valueOf(offset);
        BigInteger bLimit = BigInteger.valueOf(limit);
        String value = String.valueOf(MessageState.toInt(filter));
        this.dataMessageInfo.getListOfReceivedMessages(xmlFrom, xmlTo, null, value, bOffset, bLimit, (Holder<TRecordsArray>)records, (Holder<TStatus>)status);
        ErrorHandling.throwIfError("Nemohu stahnout seznam prijatych zprav", (TStatus)status.value);
        logger.info((Object)String.format("getListOfReceivedMessages finished", new Object[0]));
        return this.createMessages((TRecordsArray)records.value, MessageType.RECEIVED);
    }

    @Override
    public List<MessageEnvelope> getListOfSentMessages(Date from, Date to, EnumSet<MessageState> filter, int offset, int limit) {
        logger.info((Object)String.format("getListOfSentMessages: offset:%s limit:%s", offset, limit));
        Holder records = new Holder();
        Holder status = new Holder();
        XMLGregorianCalendar xmlSince = XMLUtils.toXmlDate(from);
        XMLGregorianCalendar xmlTo = XMLUtils.toXmlDate(to);
        BigInteger bOffset = BigInteger.valueOf(offset);
        BigInteger bLimit = BigInteger.valueOf(limit);
        String value = String.valueOf(MessageState.toInt(filter));
        this.dataMessageInfo.getListOfSentMessages(xmlSince, xmlTo, null, value, bOffset, bLimit, (Holder<TRecordsArray>)records, (Holder<TStatus>)status);
        ErrorHandling.throwIfError("Nemohu stahnout seznam odeslanych zprav", (TStatus)status.value);
        logger.info((Object)String.format("getListOfSentMessages finished", new Object[0]));
        return this.createMessages((TRecordsArray)records.value, MessageType.SENT);
    }

    @Override
    public List<MessageStateChange> GetMessageStateChanges(Date from, Date to) {
        logger.info((Object)String.format("GetMessageStateChanges: from:%s to:%s", from, to));
        Holder status = new Holder();
        Holder changes = new Holder();
        XMLGregorianCalendar xmlSince = null;
        if (from != null) {
            xmlSince = XMLUtils.toXmlDate(from);
        }
        XMLGregorianCalendar xmlTo = null;
        if (to != null) {
            xmlTo = XMLUtils.toXmlDate(to);
        }
        this.dataMessageInfo.getMessageStateChanges(xmlSince, xmlTo, (Holder<TStateChangesArray>)changes, (Holder<TStatus>)status);
        ErrorHandling.throwIfError("GetMessageStateChanges failed", (TStatus)status.value);
        ArrayList<MessageStateChange> result = new ArrayList<MessageStateChange>();
        for (TStateChangesRecord record : ((TStateChangesArray)changes.value).getDmRecord()) {
            MessageStateChange stateChange = new MessageStateChange();
            stateChange.setEventTime(record.getDmEventTime().toGregorianCalendar());
            stateChange.setMessageId(record.getDmID());
            stateChange.setState(MessageState.valueOf(record.getDmMessageStatus()));
            result.add(stateChange);
        }
        logger.info((Object)String.format("GetMessageStateChanges finished, result size is %s.", ((TStateChangesArray)changes.value).getDmRecord().size()));
        return result;
    }

    @Override
    public Hash verifyMessage(MessageEnvelope envelope) {
        Holder status = new Holder();
        Holder hash = new Holder();
        this.dataMessageInfo.verifyMessage(envelope.getMessageID(), (Holder<THash>)hash, (Holder<TStatus>)status);
        ErrorHandling.throwIfError("Nemohu overit hash zpravy.", (TStatus)status.value);
        return new Hash(((THash)hash.value).getAlgorithm(), ((THash)hash.value).getValue());
    }

    @Override
    public void markMessageAsDownloaded(MessageEnvelope env) {
        TStatus status = this.dataMessageInfo.markMessageAsDownloaded(env.getMessageID());
        ErrorHandling.throwIfError("Nemohu oznacit zpravu jako prectenou.", status);
    }

    @Override
    public DeliveryInfo getDeliveryInfo(MessageEnvelope env) {
        Holder status = new Holder();
        Holder delivery = new Holder();
        this.dataMessageInfo.getDeliveryInfo(env.getMessageID(), (Holder<TDelivery>)delivery, (Holder<TStatus>)status);
        ErrorHandling.throwIfError("Nemohu stahnout informace o doruceni.", (TStatus)status.value);
        return MessageValidator.buildDeliveryInfo(env, (TDelivery)delivery.value);
    }

    @Override
    public void getSignedDeliveryInfo(MessageEnvelope envelope, OutputStream os) {
        Holder status = new Holder();
        Holder signedDeliveryInfo = new Holder();
        this.dataMessageInfo.getSignedDeliveryInfo(envelope.getMessageID(), (Holder<byte[]>)signedDeliveryInfo, (Holder<TStatus>)status);
        ErrorHandling.throwIfError(String.format("Nemohu stahnout podepsanou dorucenku pro zpravu s id=%s.", envelope.getMessageID()), (TStatus)status.value);
        try {
            os.write((byte[])signedDeliveryInfo.value);
            os.flush();
            logger.info((Object)String.format("getSignedDeliveryInfo successfull", new Object[0]));
        }
        catch (IOException ioe) {
            throw new DataBoxException("Chyba pri zapisu do vystupniho proudu.", ioe);
        }
    }

    protected List<MessageEnvelope> createMessages(TRecordsArray records, MessageType type) {
        ArrayList<MessageEnvelope> result = new ArrayList<MessageEnvelope>();
        for (TRecord record : records.getDmRecord()) {
            String senderID = (String)record.getDbIDSender().getValue();
            String senderIdentity = (String)record.getDmSender().getValue();
            String senderAddress = (String)record.getDmSenderAddress().getValue();
            DataBox sender = new DataBox(senderID, senderIdentity, senderAddress);
            String recipientID = (String)record.getDbIDRecipient().getValue();
            String recipientIdentity = (String)record.getDmRecipient().getValue();
            String recipientAddress = (String)record.getDmRecipientAddress().getValue();
            DataBox recipient = new DataBox(recipientID, recipientIdentity, recipientAddress);
            String annotation = (String)record.getDmAnnotation().getValue();
            if (annotation == null) {
                annotation = "";
            }
            String messageID = record.getDmID();
            MessageEnvelope env = new MessageEnvelope(type, sender, recipient, messageID, annotation);
            if (record.getDmAcceptanceTime().getValue() != null) {
                env.setAcceptanceTime(((XMLGregorianCalendar)record.getDmAcceptanceTime().getValue()).toGregorianCalendar());
            }
            if (record.getDmDeliveryTime().getValue() != null) {
                env.setDeliveryTime(((XMLGregorianCalendar)record.getDmDeliveryTime().getValue()).toGregorianCalendar());
            }
            env.setState(MessageState.valueOf(record.getDmMessageStatus().intValue()));
            String senderIdent = (String)record.getDmSenderIdent().getValue();
            String senderRefNumber = (String)record.getDmSenderRefNumber().getValue();
            env.setSenderIdent(new DocumentIdent(senderRefNumber, senderIdent));
            String recipientIdent = (String)record.getDmRecipientIdent().getValue();
            String recipientRefNumber = (String)record.getDmRecipientRefNumber().getValue();
            env.setRecipientIdent(new DocumentIdent(recipientRefNumber, recipientIdent));
            env.setToHands((String)record.getDmToHands().getValue());
            env.setAllowSubstDelivery((Boolean)record.getDmAllowSubstDelivery().getValue());
            env.setPersonalDelivery((Boolean)record.getDmPersonalDelivery().getValue());
            result.add(env);
        }
        return result;
    }
}

