/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.impl;

import cz.abclinuxu.datoveschranky.common.Config;
import cz.abclinuxu.datoveschranky.common.DataBoxException;
import cz.abclinuxu.datoveschranky.common.Utils;
import cz.abclinuxu.datoveschranky.common.entities.Attachment;
import cz.abclinuxu.datoveschranky.common.entities.DataBox;
import cz.abclinuxu.datoveschranky.common.entities.DeliveryEvent;
import cz.abclinuxu.datoveschranky.common.entities.DeliveryInfo;
import cz.abclinuxu.datoveschranky.common.entities.DocumentIdent;
import cz.abclinuxu.datoveschranky.common.entities.Hash;
import cz.abclinuxu.datoveschranky.common.entities.Message;
import cz.abclinuxu.datoveschranky.common.entities.MessageEnvelope;
import cz.abclinuxu.datoveschranky.common.entities.MessageState;
import cz.abclinuxu.datoveschranky.common.entities.MessageType;
import cz.abclinuxu.datoveschranky.common.entities.TimeStamp;
import cz.abclinuxu.datoveschranky.common.entities.content.Content;
import cz.abclinuxu.datoveschranky.common.interfaces.AttachmentStorer;
import cz.abclinuxu.datoveschranky.impl.Validator;
import cz.abclinuxu.datoveschranky.ws.dm.TDelivery;
import cz.abclinuxu.datoveschranky.ws.dm.TDeliveryMessageOutput;
import cz.abclinuxu.datoveschranky.ws.dm.TEvent;
import cz.abclinuxu.datoveschranky.ws.dm.TFilesArray;
import cz.abclinuxu.datoveschranky.ws.dm.TMessDownOutput;
import cz.abclinuxu.datoveschranky.ws.dm.TReturnedMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageValidator {
    private static final String encoding = "UTF-8";
    private static final String startTag = "<p:dmDm";
    private static final String endTag = "</p:dmDm>";
    private Logger logger = Logger.getLogger(MessageValidator.class.getCanonicalName());
    private Validator validator;

    public MessageValidator() {
        this.validator = new Validator();
    }

    public MessageValidator(Config config) {
        this.validator = new Validator(Utils.getX509Certificates(config.getKeyStore()), false);
    }

    public Message validateAndCreateMessage(Content content, AttachmentStorer storer) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Utils.copy(content.getInputStream(), bos);
        return this.validateAndCreateMessage(bos.toByteArray(), storer, true);
    }

    public Message createMessage(Content content, AttachmentStorer storer) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Utils.copy(content.getInputStream(), bos);
        return this.validateAndCreateMessage(bos.toByteArray(), storer, false);
    }

    public Message createMessage(byte[] content, AttachmentStorer storer) throws IOException {
        return this.validateAndCreateMessage(content, storer, false);
    }

    public Message validateAndCreateMessage(byte[] asPKCS7, AttachmentStorer storer, boolean checkHash) throws DataBoxException {
        byte[] asXML = this.validator.readPKCS7(asPKCS7);
        MarshallerResult result = null;
        try {
            result = MessageValidator.load(TMessDownOutput.class, asXML);
        }
        catch (Exception ex) {
            throw new DataBoxException("Nemohu demarsalovat zpravu", ex);
        }
        TMessDownOutput out = (TMessDownOutput)((JAXBElement)result.value).getValue();
        TReturnedMessage tMessage = (TReturnedMessage)out.getDmReturnedMessage().getValue();
        MessageEnvelope envelope = null;
        if (result.rootUri.endsWith("/v20/SentMessage")) {
            envelope = this.buildMessageEnvelope(tMessage, MessageType.SENT);
        } else if (result.rootUri.endsWith("/v20/message")) {
            envelope = this.buildMessageEnvelope(tMessage, MessageType.RECEIVED);
        } else {
            this.logger.log(Level.SEVERE, String.format("Neplatny namespace '%s' u zpravy.", result.rootUri));
            envelope = this.buildMessageEnvelope(tMessage, MessageType.CREATED);
        }
        Message message = this.buildMessage(envelope, tMessage, storer);
        Hash messageHash = new Hash(tMessage.getDmHash().getAlgorithm(), tMessage.getDmHash().getValue());
        if (checkHash) {
            Hash rightHash = MessageValidator.computeMessageHash(asXML, message.getTimeStamp().getHash().getAlgorithm());
            if (!rightHash.equals(message.getTimeStamp().getHash())) {
                throw new DataBoxException("Poruseni integrity zpravy, spocitany has zpravy nen roven hasi uvedenemu v casovem razitku.");
            }
            if (!rightHash.equals(messageHash)) {
                throw new DataBoxException("Poruseni integrity zpravy, spocitany hash zpravy nen roven hasi uvedenemu ve zprave.");
            }
        }
        return message;
    }

    public DeliveryInfo createDeliveryInfo(byte[] asPCKS7) {
        byte[] asXML = this.validator.readPKCS7(asPCKS7);
        MarshallerResult result = null;
        try {
            result = MessageValidator.load(TDeliveryMessageOutput.class, asXML);
        }
        catch (Exception ex) {
            throw new DataBoxException("Nemohu demarsalovat zpravu", ex);
        }
        TDeliveryMessageOutput delivery = (TDeliveryMessageOutput)((JAXBElement)result.value).getValue();
        return MessageValidator.buildDeliveryInfo((TDelivery)delivery.getDmDelivery().getValue());
    }

    static Hash computeMessageHash(byte[] messageInXML, String algorithm) throws DataBoxException {
        try {
            String asString = new String(messageInXML, encoding);
            int startAt = asString.indexOf(startTag);
            int endAt = asString.indexOf(endTag);
            String substr = asString.substring(startAt, endAt + endTag.length());
            byte[] toHash = substr.getBytes(encoding);
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(toHash);
            return new Hash(algorithm, md.digest());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new DataBoxException(nsae.toString(), nsae);
        }
        catch (UnsupportedEncodingException uee) {
            throw new DataBoxException(uee.toString(), uee);
        }
    }

    public static DeliveryInfo buildDeliveryInfo(TDelivery delivery) {
        return MessageValidator.buildDeliveryInfo(null, delivery);
    }

    public static DeliveryInfo buildDeliveryInfo(MessageEnvelope env, TDelivery delivery) {
        XMLGregorianCalendar delivered;
        DeliveryInfo result = new DeliveryInfo();
        XMLGregorianCalendar accepted = delivery.getDmAcceptanceTime();
        if (accepted != null) {
            result.setAccepted(accepted.toGregorianCalendar());
        }
        if ((delivered = delivery.getDmDeliveryTime()) != null) {
            result.setDelivered(delivered.toGregorianCalendar());
        }
        result.setHash(new Hash(delivery.getDmHash().getAlgorithm(), delivery.getDmHash().getValue()));
        if (env != null) {
            result.setMessageEnvelope(env);
        }
        ArrayList<DeliveryEvent> events = new ArrayList<DeliveryEvent>();
        for (TEvent tEvent : delivery.getDmEvents().getDmEvent()) {
            DeliveryEvent event = new DeliveryEvent(tEvent.getDmEventTime().toGregorianCalendar(), tEvent.getDmEventDescr());
            events.add(event);
        }
        result.setEvents(events);
        return result;
    }

    MessageEnvelope buildMessageEnvelope(TReturnedMessage message, MessageType type) {
        XMLGregorianCalendar delivered;
        MessageEnvelope result = new MessageEnvelope();
        result.setState(MessageState.valueOf(message.getDmMessageStatus().intValue()));
        XMLGregorianCalendar accepted = message.getDmAcceptanceTime();
        if (accepted != null) {
            result.setAcceptanceTime(accepted.toGregorianCalendar());
        }
        if ((delivered = message.getDmDeliveryTime()) != null) {
            result.setDeliveryTime(delivered.toGregorianCalendar());
        }
        result.setType(type);
        TReturnedMessage.DmDm mess = message.getDmDm();
        return this.buildMessage(mess, result);
    }

    MessageEnvelope buildMessage(TReturnedMessage.DmDm mess, MessageEnvelope result) {
        result.setMessageID(mess.getDmID());
        result.setAnnotation(mess.getDmAnnotation());
        String senderID = mess.getDbIDSender();
        String senderIdentity = mess.getDmSender();
        String senderAddress = mess.getDmSenderAddress();
        DataBox sender = new DataBox(senderID, senderIdentity, senderAddress);
        result.setSender(sender);
        String recipientID = mess.getDbIDRecipient();
        String recipientIdentity = mess.getDmRecipient();
        String recipientAddress = mess.getDmRecipientAddress();
        DataBox recipient = new DataBox(recipientID, recipientIdentity, recipientAddress);
        result.setRecipient(recipient);
        String senderIdent = mess.getDmSenderIdent();
        String senderRefNumber = mess.getDmSenderRefNumber();
        result.setSenderIdent(new DocumentIdent(senderRefNumber, senderIdent));
        String recipientIdent = mess.getDmRecipientIdent();
        String recipientRefNumber = mess.getDmRecipientRefNumber();
        result.setRecipientIdent(new DocumentIdent(recipientRefNumber, recipientIdent));
        result.setRecipientIdent(new DocumentIdent(recipientRefNumber, recipientIdent));
        result.setToHands(mess.getDmToHands());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message buildMessage(MessageEnvelope envelope, TReturnedMessage message, AttachmentStorer storer) {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (TFilesArray.DmFile file : message.getDmDm().getDmFiles().getDmFile()) {
            Attachment attachment;
            block9: {
                attachment = new Attachment();
                attachment.setDescription(file.getDmFileDescr());
                attachment.setMetaType(file.getDmFileMetaType());
                attachment.setMimeType(file.getDmMimeType());
                OutputStream os = null;
                try {
                    try {
                        os = storer.store(envelope, attachment);
                        if (file.getDmEncodedContent() != null) {
                            os.write(file.getDmEncodedContent());
                            break block9;
                        }
                        if (file.getDmXMLContent() != null) {
                            os.write(MessageValidator.toByteArray(file.getDmXMLContent().getAny()));
                            break block9;
                        }
                        throw new IllegalArgumentException("both file.getDmEncodedContent() and file.getDmXMLContent() are null, messageId is " + envelope.getMessageID());
                    }
                    finally {
                        if (os != null) {
                            os.close();
                        }
                    }
                }
                catch (IOException ioe) {
                    throw new DataBoxException("Nelze zapisovat do vystupniho proudu", ioe);
                }
            }
            attachments.add(attachment);
        }
        TimeStamp ts = this.validator.readTimeStamp(message.getDmQTimestamp());
        return new Message(envelope, ts, null, attachments);
    }

    public Message readZFO(byte[] input, AttachmentStorer storer) {
        MarshallerResult result = null;
        try {
            result = MessageValidator.load(TMessDownOutput.class, input);
        }
        catch (Exception ex) {
            throw new DataBoxException("Nemohu demarsalovat zpravu", ex);
        }
        TMessDownOutput out = (TMessDownOutput)((JAXBElement)result.value).getValue();
        TReturnedMessage tMessage = (TReturnedMessage)out.getDmReturnedMessage().getValue();
        MessageEnvelope envelope = null;
        envelope = result.rootUri.endsWith("/v20/SentMessage") ? this.buildMessageEnvelope(tMessage, MessageType.SENT) : (result.rootUri.endsWith("/v20/message") ? this.buildMessageEnvelope(tMessage, MessageType.RECEIVED) : this.buildMessageEnvelope(tMessage, MessageType.CREATED));
        Message message = this.buildMessage(envelope, tMessage, storer);
        return message;
    }

    private static <E> MarshallerResult load(Class<E> clazz, byte[] what) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        SAXParserFactory SAXfactory = SAXParserFactory.newInstance();
        XMLReader reader = SAXfactory.newSAXParser().getXMLReader();
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        DBMessageXMLFilter xmlFilter = new DBMessageXMLFilter(reader);
        reader.setContentHandler((ContentHandler)unmarshaller.getUnmarshallerHandler());
        SAXSource source = new SAXSource(xmlFilter, new InputSource(new ByteArrayInputStream(what)));
        return new MarshallerResult(unmarshaller.unmarshal((Source)source), xmlFilter.rootURI);
    }

    protected static byte[] toByteArray(Element element) {
        try {
            DOMSource source = new DOMSource(element);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            return out.toByteArray();
        }
        catch (TransformerConfigurationException tce) {
            throw new RuntimeException(tce);
        }
        catch (TransformerException te) {
            throw new RuntimeException(te);
        }
    }

    private static class DBMessageXMLFilter
    extends XMLFilterImpl {
        private static final String namespace = "http://isds.czechpoint.cz/v20";
        public String rootURI = null;

        public DBMessageXMLFilter(XMLReader arg0) {
            super(arg0);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.rootURI == null) {
                this.rootURI = uri;
            }
            super.startElement(namespace, localName, localName, attributes);
        }
    }

    private static class MarshallerResult {
        public Object value;
        public String rootUri;

        public MarshallerResult(Object val, String uri) {
            this.value = val;
            this.rootUri = uri;
        }
    }
}

