/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.impl;

import cz.abclinuxu.datoveschranky.common.Config;
import cz.abclinuxu.datoveschranky.common.interfaces.DataBoxAccessService;
import cz.abclinuxu.datoveschranky.common.interfaces.DataBoxDownloadService;
import cz.abclinuxu.datoveschranky.common.interfaces.DataBoxMessagesService;
import cz.abclinuxu.datoveschranky.common.interfaces.DataBoxSearchService;
import cz.abclinuxu.datoveschranky.common.interfaces.DataBoxServices;
import cz.abclinuxu.datoveschranky.common.interfaces.DataBoxUploadService;
import cz.abclinuxu.datoveschranky.impl.Authentication;
import cz.abclinuxu.datoveschranky.impl.DataBoxDownloadServiceImpl;
import cz.abclinuxu.datoveschranky.impl.DataBoxMessagesServiceImpl;
import cz.abclinuxu.datoveschranky.impl.DataBoxSearchServiceImpl;
import cz.abclinuxu.datoveschranky.impl.DataBoxUploadServiceImpl;
import cz.abclinuxu.datoveschranky.impl.MessageValidator;
import cz.abclinuxu.datoveschranky.ws.ServiceBuilder;
import cz.abclinuxu.datoveschranky.ws.db.DataBoxManipulationPortType;
import cz.abclinuxu.datoveschranky.ws.dm.DmInfoPortType;
import cz.abclinuxu.datoveschranky.ws.dm.DmOperationsPortType;

public class ThreadSafeDataBoxManager
implements DataBoxServices {
    protected Authentication auth = null;
    protected Config config = null;

    public ThreadSafeDataBoxManager(Config conf, Authentication auth) {
        this.auth = auth;
        this.config = conf;
    }

    public DataBoxDownloadService getDataBoxDownloadService() {
        MessageValidator messageValidator = new MessageValidator(this.config);
        DmOperationsPortType dataMessageOperationsService = this.auth.createService(ServiceBuilder.createDmOperationsWebService(), DmOperationsPortType.class, "dz");
        return new DataBoxDownloadServiceImpl(dataMessageOperationsService, messageValidator);
    }

    public DataBoxMessagesService getDataBoxMessagesService() {
        DmInfoPortType dataMessageInfo = this.auth.createService(ServiceBuilder.createDmInfoWebService(), DmInfoPortType.class, "dx");
        return new DataBoxMessagesServiceImpl(dataMessageInfo);
    }

    public DataBoxUploadService getDataBoxUploadService() {
        DmOperationsPortType dataMessageOperationsService = this.auth.createService(ServiceBuilder.createDmOperationsWebService(), DmOperationsPortType.class, "dz");
        return new DataBoxUploadServiceImpl(dataMessageOperationsService);
    }

    public DataBoxSearchService getDataBoxSearchService() {
        DataBoxManipulationPortType service = this.auth.createService(ServiceBuilder.createDataBoxManipulation(), DataBoxManipulationPortType.class, "df");
        return new DataBoxSearchServiceImpl(service);
    }

    public DataBoxAccessService getDataBoxAccessService() {
        throw new UnsupportedOperationException("Operace getDataBoxAccessService neni touto knihovnou podporovana.");
    }
}

