/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.common.entities;

import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MessageState {
    SUBMITTED("pod\u00e1na", 1, false),
    TIMESTAMPED("opat\u0159ena \u010dasov\u00fdm raz\u00edtkem", 2, false),
    VIRUS_FOUND("nepro\u0161la antivirovou kontrolou", 3, false),
    DELIVERED("dod\u00e1na do ISDS", 4, true),
    DELIVERED_BY_FICTION("doru\u010dena fikc\u00ed", 5, true),
    DELIVERED_BY_LOGIN("doru\u010dena p\u0159ihl\u00e1\u0161en\u00edm", 6, true),
    READ("p\u0159e\u010dtena", 7, true),
    UNDELIVERABLE("nedoru\u010diteln\u00e1, DS byla zp\u011btn\u011b znep\u0159\u00edstupn\u011bna", 8, false),
    DELETED("smaz\u00e1na", 9, false),
    IN_DEPOSITORY("v datov\u00e9m trezoru", 10, true);

    private final String message;
    private final int value;
    private boolean download;

    private MessageState(String mess, int val, boolean download) {
        this.message = mess;
        this.value = val;
        this.download = download;
    }

    public static MessageState valueOf(int val) {
        for (MessageState ms : EnumSet.allOf(MessageState.class)) {
            if (ms.value != val) continue;
            return ms;
        }
        throw new IllegalArgumentException(String.format("\u010c\u00edslo %d nen\u00ed povolen\u00fd \u010d\u00edseln\u00fd stav zpr\u00e1vy.", val));
    }

    public static int toInt(EnumSet<MessageState> states) {
        if (states == null || states.size() == 0) {
            return -1;
        }
        int result = 0;
        for (MessageState state : states) {
            result |= 1 << state.value;
        }
        return result;
    }

    public boolean canBeDownloaded() {
        return this.download;
    }

    public int getValue() {
        return this.value;
    }
}

